<?php declare(strict_types=1);
/**
 *
 *           a88888P8
 *          d8'
 * .d8888b. 88        .d8888b. 88d8b.d8b. .d8888b. .dd888b. .d8888b.
 * 88ooood8 88        88'  `88 88'`88'`88 88ooood8 88'    ` 88'  `88
 * 88.  ... Y8.       88.  .88 88  88  88 88.  ... 88       88.  .88
 * `8888P'   Y88888P8 `88888P' dP  dP  dP `8888P'  dP       `88888P'
 *
 *           Copyright © eComero Management AB, All rights reserved.
 *
 */
namespace Ecomero\ErpCore\Model\Config\Source;

class CronScheduleList implements \Magento\Framework\Data\OptionSourceInterface
{
    public function toOptionArray() : array
    {
        $arr = [];
        $arr['DISABLED'] = 'Disabled';
        $arr['1MIN'] = 'Every minute';
        $arr['5MIN'] = 'Every 5th minute';
        $arr['15MIN'] = 'Every 15th minute';
        $arr['HOUR'] = 'Every hour';
        $arr['4HOUR'] = 'Every 4th hour';
        $arr['DAILY'] = 'Daily at 4:00 AM';
        $ret = [];

        foreach ($arr as $key => $value) {
            $ret[] = [
                'value' => $key,
                'label' => $value
            ];
        }

        return $ret;
    }
}
