<?php

declare(strict_types=1);
/**
 *           a88888P8
 *          d8'
 * .d8888b. 88        .d8888b. 88d8b.d8b. .d8888b. .dd888b. .d8888b.
 * 88ooood8 88        88'  `88 88'`88'`88 88ooood8 88'    ` 88'  `88
 * 88.  ... Y8.       88.  .88 88  88  88 88.  ... 88       88.  .88
 * `8888P'   Y88888P8 `88888P' dP  dP  dP `8888P'  dP       `88888P'.
 *
 *           Copyright © eComero Management AB, All rights reserved.
 */

namespace Ecomero\ErpCore\Model\Config\Source;

use Ecomero\ErpCore\Helper\Settings;
use Ecomero\ErpCore\Model\Erp\ErpShippingInterface;
use Magento\Framework\App\RequestInterface;
use Psr\Log\LoggerInterface;

class Location implements \Magento\Framework\Data\OptionSourceInterface
{
    protected $erp;
    protected $settings;
    private $logger;

    public function __construct(
        ErpShippingInterface $erp,
        Settings $settings,
        LoggerInterface $logger,
        RequestInterface $request
    ) {
        $this->erp = $erp;
        $this->settings = $settings;
        $this->logger = $logger;

        $websiteId = $request->getParam('website');
        if (null === $websiteId) {
            $websiteId = 0;
        }
        $this->erp->setWebsite((int) $websiteId);
    }

    public function toOptionArray(): array
    {
        $ret = [];
        $ret[] = [
            'value' => $this->settings->getWarehouseLocation($this->erp->getWebsite()),
            'label' => 'NO CONNECTION WITH ERP',
        ];

        try {
            $arr = [];
            $locations = $this->erp->getLocations();
            foreach ($locations as $location) {
                $arr[$location['code']] = $location['displayName'];
            }

            $ret = [];
            foreach ($arr as $key => $value) {
                $ret[] = [
                    'value' => $key,
                    'label' => $value,
                ];
            }
        } catch (\Laminas\Http\Exception\RuntimeException $exception) {
            $this->logger->debug($exception->getMessage());
        } catch (\Magento\Framework\Exception\LocalizedException $exception) {
            $this->logger->debug($exception->getMessage());
        } catch (\RuntimeException $exception) {
            $this->logger->debug($exception->getMessage());
        }

        return $ret;
    }
}
