<?php

declare(strict_types=1);
/**
 *           a88888P8
 *          d8'
 * .d8888b. 88        .d8888b. 88d8b.d8b. .d8888b. .dd888b. .d8888b.
 * 88ooood8 88        88'  `88 88'`88'`88 88ooood8 88'    ` 88'  `88
 * 88.  ... Y8.       88.  .88 88  88  88 88.  ... 88       88.  .88
 * `8888P'   Y88888P8 `88888P' dP  dP  dP `8888P'  dP       `88888P'.
 *
 *           Copyright © eComero Management AB, All rights reserved.
 */

namespace Ecomero\ErpCore\Controller\Adminhtml\Order;

use Magento\Framework\Exception\LocalizedException;
use Magento\Sales\Controller\Adminhtml\Order;

class ResendToErp extends Order
{
    public const ADMIN_RESOURCE = 'Magento_Sales::create';

    protected $orderExport;

    public function __construct(
        \Ecomero\ErpCore\Model\Order\OrderExport $orderExport,
        \Magento\Backend\App\Action\Context $context,
        \Magento\Framework\Registry $coreRegistry,
        \Magento\Framework\App\Response\Http\FileFactory $fileFactory,
        \Magento\Framework\Translate\InlineInterface $translateInline,
        \Magento\Framework\View\Result\PageFactory $resultPageFactory,
        \Magento\Framework\Controller\Result\JsonFactory $resultJsonFactory,
        \Magento\Framework\View\Result\LayoutFactory $resultLayoutFactory,
        \Magento\Framework\Controller\Result\RawFactory $resultRawFactory,
        \Magento\Sales\Api\OrderManagementInterface $orderManagement,
        \Magento\Sales\Api\OrderRepositoryInterface $orderRepository,
        \Psr\Log\LoggerInterface $logger
    ) {
        $this->orderExport = $orderExport;

        parent::__construct(
            $context,
            $coreRegistry,
            $fileFactory,
            $translateInline,
            $resultPageFactory,
            $resultJsonFactory,
            $resultLayoutFactory,
            $resultRawFactory,
            $orderManagement,
            $orderRepository,
            $logger
        );
    }

    public function execute()
    {
        $order = $this->_initOrder();

        if ($order) {
            try {
                $this->orderExport->export($order);
                $error = $this->orderExport->getLastError();
                if( $error ) {
                    $this->messageManager->addErrorMessage($error);
                } else {
                    $this->messageManager->addSuccessMessage(__('The order was successfully sent to the Erp.'));
                }
            } catch (LocalizedException $e) {
                $this->messageManager->addErrorMessage($e->getMessage());
            } catch (\Exception $e) {
                $this->messageManager->addErrorMessage(__('We can\'t re-send the order right now.'));
                $this->logger->critical($e);
            }

            return $this->resultRedirectFactory->create()->setPath(
                'sales/order/view',
                [
                    'order_id' => $order->getEntityId(),
                ]
            );
        }

        return $this->resultRedirectFactory->create()->setPath('sales/*/');
    }
}
