<?php

declare(strict_types=1);
/**
 *           a88888P8
 *          d8'
 * .d8888b. 88        .d8888b. 88d8b.d8b. .d8888b. .dd888b. .d8888b.
 * 88ooood8 88        88'  `88 88'`88'`88 88ooood8 88'    ` 88'  `88
 * 88.  ... Y8.       88.  .88 88  88  88 88.  ... 88       88.  .88
 * `8888P'   Y88888P8 `88888P' dP  dP  dP `8888P'  dP       `88888P'.
 *
 *           Copyright © eComero Management AB, All rights reserved.
 */

namespace Ecomero\ErpCore\Cron;

use Ecomero\ErpCore\Helper\ErpLogger;
use Ecomero\ErpCore\Helper\Settings;
use Ecomero\ErpCore\Model\Catalog\CatalogImport;
use Ecomero\ErpCore\Model\Invoice\InvoiceExport;
use Ecomero\ErpCore\Model\Invoice\InvoiceImport;
use Ecomero\ErpCore\Model\Order\CreditMemoExport;
use Ecomero\ErpCore\Model\Order\OrderExport;
use Ecomero\ErpCore\Model\Order\OrderImport;
use Ecomero\ErpCore\Model\Rma\RmaImport;
use Ecomero\ErpCore\Model\Shipping\ShippingImport;

class RunImport
{
    protected $catalogImport;
    protected $shippingImport;
    protected $invoiceExport;
    protected $invoiceImport;
    protected $orderExport;
    protected $orderImport;
    protected $creditMemoExport;
    protected $rmaImport;
    protected $settings;
    protected $logger;

    public function __construct(
        CatalogImport $catalogImport,
        ShippingImport $shippingImport,
        InvoiceExport $invoiceExport,
        InvoiceImport $invoiceImport,
        OrderExport $orderExport,
        OrderImport $orderImport,
        CreditMemoExport $creditMemoExport,
        RmaImport $rmaImport,
        Settings $settings,
        ErpLogger $logger
    ) {
        $this->catalogImport = $catalogImport;
        $this->shippingImport = $shippingImport;
        $this->invoiceExport = $invoiceExport;
        $this->invoiceImport = $invoiceImport;
        $this->orderExport = $orderExport;
        $this->orderImport = $orderImport;
        $this->creditMemoExport = $creditMemoExport;
        $this->rmaImport = $rmaImport;
        $this->settings = $settings;
        $this->logger = $logger;
    }

    public function executeEvery1Minute(): int
    {
        $this->executeCronRunners('1MIN');
        return 0;
    }

    public function executeEvery5Minute(): int
    {
        $this->executeCronRunners('5MIN');
        return 0;
    }

    public function executeEvery15Minute(): int
    {
        $this->executeCronRunners('15MIN');
        return 0;
    }

    public function executeEveryHour(): int
    {
        $this->executeCronRunners('HOUR');
        return 0;
    }

    public function executeEvery4thHour(): int
    {
        $this->executeCronRunners('4HOUR');
        return 0;
    }

    public function executeDailyAt4(): int
    {
        $this->executeCronRunners('DAILY');
        // Internal daily maintenance tasks
        $this->logger->deleteOldLogfiles();

        return 0;
    }

    private function executeCronRunners(string $frequence) {
        if ($frequence == $this->settings->getCronProductImport()) {
            $this->catalogImport->executeFromCron();
        }
        if ($frequence == $this->settings->getCronOrderExport()) {
            $this->orderExport->executeFromCron();
        }
        if ($frequence == $this->settings->getCronOrderImport()) {
            $this->orderImport->executeFromCron();
        }
        if ($frequence == $this->settings->getCronInvoiceExport()) {
            $this->invoiceExport->executeFromCron();
        }
        if ($frequence == $this->settings->getCronCreditMemoExport()) {
            $this->creditMemoExport->executeFromCron();
        }
        if ($frequence == $this->settings->getCronShipmentImport()) {
            $this->shippingImport->executeFromCron();
        }
        if ($frequence == $this->settings->getCronInvoiceImport()) {
            $this->invoiceImport->executeFromCron();
        }
        if ($frequence == $this->settings->getCronReturnImport()) {
            $this->rmaImport->executeFromCron();
        }
    }
}
