<?php
declare(strict_types=1);
/**
 *           a88888P8
 *          d8'
 * .d8888b. 88        .d8888b. 88d8b.d8b. .d8888b. .dd888b. .d8888b.
 * 88ooood8 88        88'  `88 88'`88'`88 88ooood8 88'    ` 88'  `88
 * 88.  ... Y8.       88.  .88 88  88  88 88.  ... 88       88.  .88
 * `8888P'   Y88888P8 `88888P' dP  dP  dP `8888P'  dP       `88888P'.
 *
 *           Copyright © eComero Management AB, All rights reserved.
 */

namespace Ecomero\ErpCore\Plugin\Magento\Backend\Block\Widget\Button;


class Toolbar
{
    public function beforePushButtons(
        \Magento\Backend\Block\Widget\Button\Toolbar $subject,
        $context,
        $buttonList
    ) {
        $request = $context->getRequest();

        if ('sales_order_view' === $request->getFullActionName()) {
            $url = $context->getUrl('sales/*/resendToErp');

            $buttonList->add('resend_to_erp', [
                'label' => __('Resend to Erp'),
                'onclick' => "setLocation('{$url}')",
                'class' => 'reset'
            ]);
        }

        return [$context, $buttonList];
    }
}
