<?php

declare(strict_types=1);
/**
 *           a88888P8
 *          d8'
 * .d8888b. 88        .d8888b. 88d8b.d8b. .d8888b. .dd888b. .d8888b.
 * 88ooood8 88        88'  `88 88'`88'`88 88ooood8 88'    ` 88'  `88
 * 88.  ... Y8.       88.  .88 88  88  88 88.  ... 88       88.  .88
 * `8888P'   Y88888P8 `88888P' dP  dP  dP `8888P'  dP       `88888P'.
 *
 *           Copyright © eComero Management AB, All rights reserved.
 */

namespace Ecomero\ErpCore\Console\Command;

use Ecomero\ErpCore\Helper\Capability as CapabilityHelper;
use Ecomero\ErpCore\Model\Shipping\ShippingImport;
use Magento\Framework\App\State;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

class ImportShipments extends \Symfony\Component\Console\Command\Command
{
    protected $state;
    protected $shipmentImport;
    protected $capabilityHelper;

    public function __construct(
        State $state,
        ShippingImport $shipmentImport,
        CapabilityHelper $capabilityHelper
    ) {
        $this->state = $state;
        $this->shipmentImport = $shipmentImport;
        $this->capabilityHelper = $capabilityHelper;

        parent::__construct();
    }

    public function isVerbose(OutputInterface $output): bool
    {
        return $output->getVerbosity() >= OutputInterface::VERBOSITY_VERBOSE;
    }

    protected function configure(): void
    {
        if (!$this->capabilityHelper->checkCapability(\Ecomero\ErpCore\Model\Capability::SHIPMENT_IMPORT)) {
            $this->setHidden(true);
        }

        $this->setName('erp:import:shipments')
            ->setDescription('Import shipment documents from ERP')
        ;

        parent::configure();
    }

    protected function execute(InputInterface $input, OutputInterface $output): int
    {
        $this->state->setAreaCode(\Magento\Framework\App\Area::AREA_ADMINHTML);

        $this->shipmentImport->executeFromShell($output, true);

        return \Magento\Framework\Console\Cli::RETURN_SUCCESS;
    }
}
