<?php

declare(strict_types=1);

namespace Ecomero\ErpCore\Helper;

use Magento\Framework\Mail\Template\TransportBuilder;
use Magento\Sales\Model\Order;

class Email
{
    protected $transportBuilder;
    protected $settings;

    public function __construct(
        TransportBuilder $transportBuilder,
        Settings $settings
    ) {
        $this->transportBuilder = $transportBuilder;
        $this->settings = $settings;
    }

    public function sendOrderStatus(Order $order, string $deliverDate): void
    {
        if (!$this->settings->isSendOrderStatusUpdate()) {
            return;
        }
        $this->transportBuilder
            ->setTemplateIdentifier($this->settings->getOrderStatusEmailTemplate())
            ->setTemplateOptions(
                [
                    'area' => \Magento\Framework\App\Area::AREA_FRONTEND,
                    'store' => $order->getStoreId(),
                ]
            )
            ->setTemplateVars(
                [
                    'deliveryDate' => $deliverDate,
                ]
            )
            ->setFrom(
                [
                    'name' => $this->settings->getSalesRepresentativeName(),
                    'email' => $this->settings->getSalesRepresentativeEmail(),
                ]
            )
            ->addTo($order->getCustomerEmail())
            ->getTransport()
            ->sendMessage()
        ;
    }
}
