<?php declare(strict_types=1);
/**
 *
 *           a88888P8
 *          d8'
 * .d8888b. 88        .d8888b. 88d8b.d8b. .d8888b. .dd888b. .d8888b.
 * 88ooood8 88        88'  `88 88'`88'`88 88ooood8 88'    ` 88'  `88
 * 88.  ... Y8.       88.  .88 88  88  88 88.  ... 88       88.  .88
 * `8888P'   Y88888P8 `88888P' dP  dP  dP `8888P'  dP       `88888P'
 *
 *           Copyright © eComero Management AB, All rights reserved.
 *
 */
namespace Ecomero\ErpCore\Plugin;

use Ecomero\ErpCore\Helper\Settings;
use Magento\Framework\DataObjectFactory;

class TrackPlugin
{
    protected $settings;
    protected $doFactory;

    public function __construct(
        Settings $settings,
        DataObjectFactory $doFactory
    ) {
        $this->settings = $settings;
        $this->doFactory = $doFactory;
    }

    public function afterGetNumberDetail(\Magento\Shipping\Model\Order\Track $trackObj, $result)
    {
        $webSiteId = (int)$trackObj->getStore()->getWebsiteId();
        $url = $this->settings->getShippingTrackUrl($webSiteId, $trackObj->getDescription());

        if ($url !== '' && $trackObj->getTrackNumber()) {
            $resultObj = $this->doFactory->create();
            $resultObj->setTracking($trackObj->getTrackNumber());
            $resultObj->setCarrierTitle($trackObj->getDescription());
            $resultObj->setUrl($url . $trackObj->getTrackNumber());
            return $resultObj;
        }
        return $result;
    }
}
