<?php

declare(strict_types=1);
/**
 *           a88888P8
 *          d8'
 * .d8888b. 88        .d8888b. 88d8b.d8b. .d8888b. .dd888b. .d8888b.
 * 88ooood8 88        88'  `88 88'`88'`88 88ooood8 88'    ` 88'  `88
 * 88.  ... Y8.       88.  .88 88  88  88 88.  ... 88       88.  .88
 * `8888P'   Y88888P8 `88888P' dP  dP  dP `8888P'  dP       `88888P'.
 *
 *           Copyright © eComero Management AB, All rights reserved.
 */

namespace Ecomero\ErpCore\Model\Erp;

interface ErpCreditMemoInterface extends ErpAdapterInterface
{
    public function createCreditMemo(
        string $creditMemoDate,
        string $orderNumber,
        ?string $invoiceNumber,
        string $customerNumber,
        string $currencyCode
    ): object;

    public function addCreditMemoItem(
        string $creditMemoNumber,
        string $bcItemId,
        float $price,
        float $qtyOrdered,
        string $vatCode,
        float $discountAmount,
        float $discountPercent,
        ?string $locationId
    ): void;

    public function postCreditMemo(string $creditMemoId): void;
}
