<?php

declare(strict_types=1);
/**
 *           a88888P8
 *          d8'
 * .d8888b. 88        .d8888b. 88d8b.d8b. .d8888b. .dd888b. .d8888b.
 * 88ooood8 88        88'  `88 88'`88'`88 88ooood8 88'    ` 88'  `88
 * 88.  ... Y8.       88.  .88 88  88  88 88.  ... 88       88.  .88
 * `8888P'   Y88888P8 `88888P' dP  dP  dP `8888P'  dP       `88888P'.
 *
 *           Copyright © eComero Management AB, All rights reserved.
 */

namespace Ecomero\ErpCore\Model\Erp;

use Ecomero\ErpCore\Helper\ErpLogger;

class ErpAdapter implements ErpAdapterInterface
{
    protected static $currentWebsite;
    protected $storeManager;
    protected $logger;

    public function __construct(
        \Magento\Store\Model\StoreManagerInterface $storeManager
    ) {
        $this->storeManager = $storeManager;
    }

    public function setWebsite(int $currentWebsite): void
    {
        self::$currentWebsite = $currentWebsite;
    }

    public function setWebsiteFromStoredId(int $storeId): void
    {
        $store = $this->storeManager->getStore($storeId);
        self::$currentWebsite = (int) $store->getWebsiteId();
    }

    public function getWebsite(): int
    {
        return self::$currentWebsite;
    }

    public function isErpEnabled(): string
    {
        return '';
    }

    public function getCapabilities(): array
    {
        return [];
    }

    public function setLogger(ErpLogger $logger): void
    {
        $this->logger = $logger;
    }
}
