<?php declare(strict_types=1);
/**
 *
 *           a88888P8
 *          d8'
 * .d8888b. 88        .d8888b. 88d8b.d8b. .d8888b. .dd888b. .d8888b.
 * 88ooood8 88        88'  `88 88'`88'`88 88ooood8 88'    ` 88'  `88
 * 88.  ... Y8.       88.  .88 88  88  88 88.  ... 88       88.  .88
 * `8888P'   Y88888P8 `88888P' dP  dP  dP `8888P'  dP       `88888P'
 *
 *           Copyright © eComero Management AB, All rights reserved.
 *
 */
namespace Ecomero\ErpCore;

class ApiRequestException extends \RuntimeException
{
    private $url;
    private $statusCode;
    private $resonseBody;

    /**
     * Constructor
     */
    public function __construct(string $message, string $url, string $statusCode, string $resonseBody)
    {
        parent::__construct($message);

        $this->url = $url;
        $this->statusCode = $statusCode;
        $this->resonseBody = $resonseBody;
    }

    /**
     * Gets URL
     *
     * @return string
     */
    public function getUrl() : string
    {
        return $this->url;
    }

    /**
     * Get status code
     *
     * @return string
     */
    public function getStatusCode() : string
    {
        return $this->statusCode;
    }

    /**
     * Get resonse body
     *
     * @return string
     */
    public function getResonseBody() : string
    {
        return $this->resonseBody;
    }
}
