define(['uiCollection', 'jquery', 'Magento_Ui/js/modal/confirm'], function (UiCollection, $, confirmation) {
    'use strict';

    return UiCollection.extend({
        confirmAndExecute: function (title, content, command) {
            confirmation({
                title: title,
                content: content,
                actions: {
                    confirm: function () {
                        this.onExecuteCommand(command);
                    }.bind(this)
                }
            });
        },

        onExportOrders: function () {
            this.confirmAndExecute(
                $.mage.__('Export orders'),
                $.mage.__('Do you want to export pending orders to the ERP?'),
                'export_orders'
            );
        },

        onImportOrders: function () {
            this.confirmAndExecute(
                $.mage.__('Import orders'),
                $.mage.__('Do you want to import order status from the ERP?'),
                'import_orders'
            );
        },

        onExportInvoices: function () {
            this.confirmAndExecute(
                $.mage.__('Export invoices'),
                $.mage.__('Do you want to export pending invoices to the ERP?'),
                'export_invoices'
            );
        },

        onExportCreditMemos: function () {
            this.confirmAndExecute(
                $.mage.__('Export credit memos'),
                $.mage.__('Do you want to export pending credit memos to the ERP?'),
                'export_credit_memos'
            );
        },

        onImportShipments: function () {
            this.confirmAndExecute(
                $.mage.__('Import shipment documents'),
                $.mage.__('Do you want to import new shipment documents from the ERP?'),
                'import_shipments'
            );
        },

        onImportInvoices: function () {
            this.confirmAndExecute(
                $.mage.__('Import invoices'),
                $.mage.__('Do you want to import new invoices from the ERP?'),
                'import_invoices'
            );
        },

        onImportReturns: function () {
            this.confirmAndExecute(
                $.mage.__('Import returns'),
                $.mage.__('Do you want to import new returns from the ERP?'),
                'import_returns'
            );
        },

        onImportProducts: function () {
            this.confirmAndExecute(
                $.mage.__('Import products'),
                $.mage.__('Do you want to import products from the ERP?'),
                'import_products'
            );
        },

        onImportPriceLists: function () {
            this.confirmAndExecute(
                $.mage.__('Import price lists'),
                $.mage.__('Do you want to import price lists from the ERP?'),
                'import_price_list'
            );
        },

        onImportCompanies: function () {
            this.confirmAndExecute(
                $.mage.__('Import companies/customers'),
                $.mage.__('Do you want to import companies/customers from the ERP?'),
                'import_company'
            );
        },        

        onExportImages: function () {
            this.confirmAndExecute(
                $.mage.__('Export product images'),
                $.mage.__('Do you want to export product images to the ERP?'),
                'export_images'
            );
        },

        onDownload: function () {
            var a = document.createElement('a');

            a.style.display = 'none';
            document.body.appendChild(a);

            a.href = this.baseUrl + '/feed?type=' + this.logType + '&lines=1000000';
            a.setAttribute('download', this.logType + '.log');
            a.click();

            document.body.removeChild(a);
        },

        onExecuteCommand: function (command) {
            $.post(this.baseUrl + '/CommandControl', { command: command }, function () {
                console.log(command);
            });
        }
    });
});
