<?php

namespace Ecomero\ErpCore\Block\Adminhtml\Config\Form\Field;

use Ecomero\ErpCore\Model\Erp\ErpCatalogInterface;
use Magento\Config\Block\System\Config\Form\Field;

class ErpModuleVersion extends Field
{
    protected $erp;

    public function __construct(
        ErpCatalogInterface $erp
    ) {
        $this->erp = $erp;
    }

    public function render(\Magento\Framework\Data\Form\Element\AbstractElement $element)
    {
        $html = '<td class="label"><label for="'.
        $element->getHtmlId().'"><span>'.
        $element->getLabel().
        '</span></label></td>';

        $html .= '<td class="value">';

        try {
            $html .= $this->erp->getErpExtVersion();
        } catch (\Throwable $exception) {
        }

        $html .= '</td>';

        return $this->_decorateRowHtml($element, $html);
    }
}
