<?php

declare(strict_types=1);
/**
 *           a88888P8
 *          d8'
 * .d8888b. 88        .d8888b. 88d8b.d8b. .d8888b. .dd888b. .d8888b.
 * 88ooood8 88        88'  `88 88'`88'`88 88ooood8 88'    ` 88'  `88
 * 88.  ... Y8.       88.  .88 88  88  88 88.  ... 88       88.  .88
 * `8888P'   Y88888P8 `88888P' dP  dP  dP `8888P'  dP       `88888P'.
 *
 *           Copyright © eComero Management AB, All rights reserved.
 */

namespace Ecomero\ErpCore\Helper;

use Ecomero\ErpCore\Model\Catalog\CatalogImport;
use Magento\Framework\Stdlib\ArrayManager;
use Magento\Sales\Model\ResourceModel\Order\Tax\Item;

class TaxItemHelper
{
    protected $taxItem;
    protected $catalogImport;
    protected $defaultTaxCode;

    public function __construct(
        Item $taxItem,
        CatalogImport $catalogImport,
        ArrayManager $arrayManager
    ) {
        $this->taxItem = $taxItem;
        $this->catalogImport = $catalogImport;
        $this->arrayManager = $arrayManager;
    }

    public function setDefaultTaxCode(?string $defaultTaxCode)
    {
        $this->defaultTaxCode = $defaultTaxCode ? $defaultTaxCode : '';
    }

    public function getDefaultTaxCode()
    {
        return $this->defaultTaxCode;
    }

    public function getTaxCodeForOrderLine(string $orderId, ?string $itemId): string
    {
        $taxItems = $this->taxItem->getTaxItemsByOrderId($orderId);
        foreach ($taxItems as $taxItem) {
            if ($taxItem['item_id'] == $itemId) {
                return $taxItem['code'];
            }
        }

        return $this->defaultTaxCode;
    }

    public function getTaxCodeForFirstProduct(string $orderId): string
    {
        $taxItems = $this->taxItem->getTaxItemsByOrderId($orderId);
        foreach ($taxItems as $taxItem) {
            if ('product' === $taxItem['taxable_item_type']) {
                return $taxItem['code'];
            }
        }

        return $this->defaultTaxCode;
    }

    public function getShippingTaxCodeForOrder(string $orderId): string
    {
        $taxItems = $this->taxItem->getTaxItemsByOrderId($orderId);
        foreach ($taxItems as $taxItem) {
            if ('shipping' === $taxItem['taxable_item_type']) {
                return $taxItem['code'];
            }
        }

        return $this->defaultTaxCode;
    }

    public function getPriceIncludesTaxForFirstProduct(\Magento\Sales\Model\Order $order): bool
    {
        $orderItems = $order->getAllItems();
        foreach ($orderItems as $item) {
            if (\Magento\Catalog\Model\Product\Type::TYPE_SIMPLE !== $item->getProductType()) {
                continue;
            }
            $bcItem = $this->catalogImport->getErpItemInfoFromSKU($item->getSku());
            $isTaxIncluded = $this->arrayManager->get('erp_tax_included', $bcItem);
            if ($isTaxIncluded && '1' == $isTaxIncluded) {
                return true;
            }
        }

        return false;
    }
}
