<?php

declare(strict_types=1);
/**
 *           a88888P8
 *          d8'
 * .d8888b. 88        .d8888b. 88d8b.d8b. .d8888b. .dd888b. .d8888b.
 * 88ooood8 88        88'  `88 88'`88'`88 88ooood8 88'    ` 88'  `88
 * 88.  ... Y8.       88.  .88 88  88  88 88.  ... 88       88.  .88
 * `8888P'   Y88888P8 `88888P' dP  dP  dP `8888P'  dP       `88888P'.
 *
 *           Copyright © eComero Management AB, All rights reserved.
 */

namespace Ecomero\ErpCore\Block\Adminhtml\Config\Form\Field;

use Magento\Catalog\Model\Product\AttributeSet\Options;
use Magento\Framework\View\Element\Context;

class AttributeSet extends \Magento\Framework\View\Element\Html\Select
{
    protected $attributeSetList;

    public function __construct(
        Context $context,
        Options $attributeSetList,
        array $data = []
    ) {
        parent::__construct($context, $data);
        $this->attributeSetList = $attributeSetList;
    }

    public function _toHtml(): string
    {
        if (!$this->getOptions()) {
            try {
                foreach ($this->attributeSetList->toOptionArray() as $option) {
                    $this->addOption($option['value'], $option['label']);
                }
            } catch (\Laminas\Http\Exception\RuntimeException $exception) {
            } catch (\Magento\Framework\Exception\LocalizedException $exception) {
            } catch (\RuntimeException $exception) {
            }
        }

        return parent::_toHtml();
    }

    public function setInputName(string $value): object
    {
        return $this->setName($value);
    }
}
