<?php declare(strict_types=1);
/**
 *
 *           a88888P8
 *          d8'
 * .d8888b. 88        .d8888b. 88d8b.d8b. .d8888b. .dd888b. .d8888b.
 * 88ooood8 88        88'  `88 88'`88'`88 88ooood8 88'    ` 88'  `88
 * 88.  ... Y8.       88.  .88 88  88  88 88.  ... 88       88.  .88
 * `8888P'   Y88888P8 `88888P' dP  dP  dP `8888P'  dP       `88888P'
 *
 *           Copyright © eComero Management AB, All rights reserved.
 *
 */
namespace Ecomero\ErpCore\Model\Config\Source;

class LogRetentionList implements \Magento\Framework\Data\OptionSourceInterface
{
    public function toOptionArray() : array
    {
        $arr = [];
        $arr['RETENTION_1_DAY'] = '24 hours';
        $arr['RETENTION_7_DAY'] = '7 days';
        $arr['RETENTION_14_DAY'] = '14 days';
        $arr['RETENTION_30_DAY'] = '1 month';
        $arr['RETENTION_90_DAY'] = '3 month';
        $arr['RETENTION_FOREVER'] = 'Forever';
        $ret = [];

        foreach ($arr as $key => $value) {
            $ret[] = [
                'value' => $key,
                'label' => $value
            ];
        }

        return $ret;
    }
}
