<?php

declare(strict_types=1);
/**
 *           a88888P8
 *          d8'
 * .d8888b. 88        .d8888b. 88d8b.d8b. .d8888b. .dd888b. .d8888b.
 * 88ooood8 88        88'  `88 88'`88'`88 88ooood8 88'    ` 88'  `88
 * 88.  ... Y8.       88.  .88 88  88  88 88.  ... 88       88.  .88
 * `8888P'   Y88888P8 `88888P' dP  dP  dP `8888P'  dP       `88888P'.
 *
 *           Copyright © eComero Management AB, All rights reserved.
 */

namespace Ecomero\ErpCore\Helper;

use Ecomero\ErpCore\Model\Erp\ErpAdapterInterface;

class Capability
{
    private $adapter;

    public function __construct(ErpAdapterInterface $adapter)
    {
        $this->adapter = $adapter;
    }

    public function checkCapability(string $capabilityType): bool
    {
        $capabilities = $this->adapter->getCapabilities();
        foreach ($capabilities as $capability) {
            if ($capability->isCapabilitySupported($capabilityType)) {
                return true;
            }
        }

        return false;
    }
}
