<?php

declare(strict_types=1);
/**
 *           a88888P8
 *          d8'
 * .d8888b. 88        .d8888b. 88d8b.d8b. .d8888b. .dd888b. .d8888b.
 * 88ooood8 88        88'  `88 88'`88'`88 88ooood8 88'    ` 88'  `88
 * 88.  ... Y8.       88.  .88 88  88  88 88.  ... 88       88.  .88
 * `8888P'   Y88888P8 `88888P' dP  dP  dP `8888P'  dP       `88888P'.
 *
 *           Copyright © eComero Management AB, All rights reserved.
 */

namespace Ecomero\ErpCore\Model\Erp;

interface ErpCustomerInterface extends ErpAdapterInterface
{
    public function getCustomerCategories(): array;

    public function getCustomerDistricts(): array;

    public function getCustomerFromEmail(string $email): array;

    public function createCustomer(
        ?string $company,
        ?string $firstName,
        ?string $lastName,
        ?string $street,
        ?string $city,
        ?string $postCode,
        ?string $email,
        ?string $phone,
        ?string $country,
        ?string $region,
        ?string $vatNumber
    ): array;

    public function getCompanyList(): array;
}
