<?php declare(strict_types=1);
/**
 *
 *           a88888P8
 *          d8'
 * .d8888b. 88        .d8888b. 88d8b.d8b. .d8888b. .dd888b. .d8888b.
 * 88ooood8 88        88'  `88 88'`88'`88 88ooood8 88'    ` 88'  `88
 * 88.  ... Y8.       88.  .88 88  88  88 88.  ... 88       88.  .88
 * `8888P'   Y88888P8 `88888P' dP  dP  dP `8888P'  dP       `88888P'
 *
 *           Copyright © eComero Management AB, All rights reserved.
 *
 */
namespace Ecomero\ErpCore\Model\Config\Source;

use Magento\Catalog\Model\CategoryFactory;
use Magento\Catalog\Model\CategoryRepository;
use Magento\Framework\App\Helper\Context;
use Magento\Store\Model\StoreManagerInterface;
use Magento\Catalog\Model\ResourceModel\Category\TreeFactory;

class CategoryList extends \Magento\Framework\App\Helper\AbstractHelper implements \Magento\Framework\Data\OptionSourceInterface
{
    protected $categoryFactory;
    protected $storeManager;
    protected $categoryRepository;
    protected $categoryList;
    protected $categoryTreeFactory;

    public function __construct(
        Context $context,
        CategoryFactory $categoryFactory,
        StoreManagerInterface $storeManager,
        CategoryRepository $categoryRepository,
        TreeFactory $categoryTreeFactory
    ) {
        $this->categoryFactory = $categoryFactory;
        $this->storeManager = $storeManager;
        $this->categoryRepository = $categoryRepository;
        $this->categoryTreeFactory = $categoryTreeFactory;
        parent::__construct($context);
    }

    public function getStoreCategories(bool $sorted = false, bool $asCollection = false, bool $toLoad = true) : object
    {
        $websiteId = $this->_request->getParam('website');
        $selectedStore = $this->storeManager->getWebsite($websiteId)->getDefaultStore()->getId();
        $this->storeManager->setCurrentStore($selectedStore);

        $parent = $this->storeManager->getStore()->getRootCategoryId();

        /**
         * Check if parent node of the store still exists
         */
        $category = $this->categoryFactory->create();
        /* @var $category ModelCategory */
        if (!$category->checkId($parent)) {
            if ($asCollection) {
                return $this->_dataCollectionFactory->create();
            }
            return [];
        }

        $recursionLevel = max(
            0,
            (int)$this->scopeConfig->getValue(
                'catalog/navigation/max_depth',
                \Magento\Store\Model\ScopeInterface::SCOPE_STORE
            )
        );

        $tree = $this->categoryTreeFactory->create();
        /* @var $tree \Magento\Catalog\Model\ResourceModel\Category\Tree */
        $nodes = $tree->loadNode($parent)->loadChildren($recursionLevel)->getChildren();

        $tree->addCollectionData(null, $sorted, $parent, $toLoad, false);

        return $nodes;
    }

    public function toOptionArray() : array
    {
        $arr = $this->toArray();
        $ret = [];

        if ($arr != null) {
            foreach ($arr as $key => $value) {
                $ret[] = [
                    'value' => $key,
                    'label' => $value
                ];
            }
        }

        return $ret;
    }

    public function toArray() : ?array
    {
        $categories = $this->getStoreCategories(true, false, true);
        $categoryList = $this->renderCategories($categories);
        return $categoryList;
    }

    public function renderCategories(object $categories) : ?array
    {
        foreach ($categories as $category) {
            $i = 0;
            $this->categoryList[$category->getEntityId()] = __($category->getName());   // Main categories
            $list = $this->renderSubCat($category, (int)$i);
        }

        return $this->categoryList;
    }

    public function renderSubCat(object $cat, int $j) : ?array
    {
        $categoryObj = $this->categoryRepository->get($cat->getId());

        $level = $categoryObj->getLevel();
        $arrow = str_repeat("...", $level-1);
        $subcategories = $categoryObj->getChildrenCategories();

        foreach ($subcategories as $subcategory) {
            $this->categoryList[$subcategory->getEntityId()] = __($arrow . $subcategory->getName());

            if ($subcategory->hasChildren()) {
                $this->renderSubCat($subcategory, $j);
            }
        }

        return $this->categoryList;
    }
}
