<?php

declare(strict_types=1);
/**
 *           a88888P8
 *          d8'
 * .d8888b. 88        .d8888b. 88d8b.d8b. .d8888b. .dd888b. .d8888b.
 * 88ooood8 88        88'  `88 88'`88'`88 88ooood8 88'    ` 88'  `88
 * 88.  ... Y8.       88.  .88 88  88  88 88.  ... 88       88.  .88
 * `8888P'   Y88888P8 `88888P' dP  dP  dP `8888P'  dP       `88888P'.
 *
 *           Copyright © eComero Management AB, All rights reserved.
 */

namespace Ecomero\ErpCore\Helper;

use Magento\Framework\Lock\LockManagerInterface;

class CronLock
{
    public const CRON_LOCK = 'ERP-CRON-LOCK';
    protected $lockManager;

    public function __construct(
        LockManagerInterface $lockManager
    ) {
        $this->lockManager = $lockManager;
    }

    public function releaseLock(): void
    {
        $this->lockManager->unlock(self::CRON_LOCK);
    }

    public function requestLock(ErpLogger $logger): bool
    {
        if ($this->lockManager->isLocked(self::CRON_LOCK)) {
            $logger->warning('*** A lock was detected, another job may be running.');
            $logger->warning('*** This can happen if you manually start a job when another job is running.');
            $logger->warning('*** If this is the case, the lock is released automatically when'.
                             ' the current job is finished.');

            return false;
        }

        $this->lockManager->lock(self::CRON_LOCK);

        return true;
    }
}
