<?php declare(strict_types=1);
/**
 *
 *           a88888P8
 *          d8'
 * .d8888b. 88        .d8888b. 88d8b.d8b. .d8888b. .dd888b. .d8888b.
 * 88ooood8 88        88'  `88 88'`88'`88 88ooood8 88'    ` 88'  `88
 * 88.  ... Y8.       88.  .88 88  88  88 88.  ... 88       88.  .88
 * `8888P'   Y88888P8 `88888P' dP  dP  dP `8888P'  dP       `88888P'
 *
 *           Copyright © eComero Management AB, All rights reserved.
 *
 */
namespace Ecomero\ErpCore\Block\Adminhtml;

use Magento\Backend\Block\Template\Context;
use Magento\Backend\Helper\Data;

class Synchronization extends \Magento\Backend\Block\Template
{
    protected $helper;

    public function __construct(
        Data $helper,
        Context $context,
        array $data = []
    ) {
        parent::__construct($context, $data);
        $this->helper = $helper;
    }

    public function getJsLayout() : string
    {
        $feedUrl =  '/' . $this->helper->getAreaFrontName() .
                    $this->jsLayout['components']['logviewer']['config']['baseUrl'];

        $this->jsLayout['components']['logviewer']['config']['baseUrl'] = $feedUrl;
        return json_encode($this->jsLayout);
    }
}
