<?php declare(strict_types=1);
/**
 *
 *           a88888P8
 *          d8'
 * .d8888b. 88        .d8888b. 88d8b.d8b. .d8888b. .dd888b. .d8888b.
 * 88ooood8 88        88'  `88 88'`88'`88 88ooood8 88'    ` 88'  `88
 * 88.  ... Y8.       88.  .88 88  88  88 88.  ... 88       88.  .88
 * `8888P'   Y88888P8 `88888P' dP  dP  dP `8888P'  dP       `88888P'
 *
 *           Copyright © eComero Management AB, All rights reserved.
 *
 */
namespace Ecomero\ErpCore\Helper;

use Magento\Framework\App\Helper\AbstractHelper;
use Magento\Framework\App\Helper\Context;
use Magento\Framework\Mail\Template\TransportBuilder;
use Magento\Framework\Translate\Inline\StateInterface;
use Magento\Store\Model\ScopeInterface;
use Magento\Store\Model\StoreManagerInterface;

class Notification extends AbstractHelper
{
    const XML_PATH_EMAIL_SENDER = 'contact/email/sender_email_identity';

    private $storeManager;
    private $inlineTranslation;
    private $transportBuilder;
    private $settings;

    public function __construct(
        Context $context,
        StoreManagerInterface $storeManager,
        StateInterface $inlineTranslation,
        TransportBuilder $transportBuilder,
        Settings $settings
    ) {
        parent::__construct($context);
        $this->storeManager = $storeManager;
        $this->inlineTranslation = $inlineTranslation;
        $this->transportBuilder = $transportBuilder;
        $this->settings = $settings;
    }

    public function emailSender() : ?string
    {
        return $this->scopeConfig->getValue(
            self::XML_PATH_EMAIL_SENDER,
            ScopeInterface::SCOPE_STORE
        );
    }

    public function notify(string $errorMessage) : Notification
    {
        if ($this->settings->getNotificationReceiver()) {
            $this->inlineTranslation->suspend();
            $this->transportBuilder->setTemplateIdentifier('erp_cron_template_notification')
                                    ->setTemplateOptions(
                                        [
                                            'area' => \Magento\Framework\App\Area::AREA_ADMINHTML,
                                            'store' => $this->storeManager->getStore()->getId(),
                                        ]
                                    )
                                    ->setTemplateVars([ 'message' => $errorMessage ])
                                    ->setFrom($this->emailSender())
                                    ->addTo($this->settings->getNotificationReceiver(), '');

            $transport = $this->transportBuilder->getTransport();
            $transport->sendMessage();
            $this->inlineTranslation->resume();
        }
        return $this;
    }
}
