<?php declare(strict_types=1);
/**
 *
 *           a88888P8
 *          d8'
 * .d8888b. 88        .d8888b. 88d8b.d8b. .d8888b. .dd888b. .d8888b.
 * 88ooood8 88        88'  `88 88'`88'`88 88ooood8 88'    ` 88'  `88
 * 88.  ... Y8.       88.  .88 88  88  88 88.  ... 88       88.  .88
 * `8888P'   Y88888P8 `88888P' dP  dP  dP `8888P'  dP       `88888P'
 *
 *           Copyright © eComero Management AB, All rights reserved.
 *
 */
namespace Ecomero\ErpCore\Block\Adminhtml;

use Ecomero\ErpCore\Helper\Settings;
use Magento\Backend\Block\Widget\Context;
use Magento\Catalog\Model\Product\TypeFactory;
use Magento\Catalog\Model\ProductFactory;

class Product extends \Magento\Catalog\Block\Adminhtml\Product
{
    protected $settings;

    public function __construct(
        Context $context,
        TypeFactory $typeFactory,
        ProductFactory $productFactory,
        Settings $settings,
        array $data = []
    ) {
        $this->settings = $settings;
        parent::__construct($context, $typeFactory, $productFactory, $data);
    }

    protected function _prepareLayout() : ?\Magento\Catalog\Block\Adminhtml\Product
    {
        if ($this->settings->getAllowNewProducts()) {
            return parent::_prepareLayout();
        }
        return null;
    }
}
