<?php

declare(strict_types=1);
/**
 *           a88888P8
 *          d8'
 * .d8888b. 88        .d8888b. 88d8b.d8b. .d8888b. .dd888b. .d8888b.
 * 88ooood8 88        88'  `88 88'`88'`88 88ooood8 88'    ` 88'  `88
 * 88.  ... Y8.       88.  .88 88  88  88 88.  ... 88       88.  .88
 * `8888P'   Y88888P8 `88888P' dP  dP  dP `8888P'  dP       `88888P'.
 *
 *           Copyright © eComero Management AB, All rights reserved.
 */

namespace Ecomero\ErpCore\Model\Erp;

interface ErpCatalogInterface extends ErpAdapterInterface
{
    public const DISCOUNT_BASE_PRICE = 5;  // Grundpris
    public const PRICE_TYPE_DISCOUNT = 'R'; // Rabatt

    public function getItemList(string $category, bool $force): array;

    public function setItemImportCompleted(): void;

    public function getItemPrices(string $category): array;

    public function getItemPriceLists(): array;

    public function getItemAttributes(string $category): array;

    public function getNonInventoryItems(): array;

    public function addPicture(string $itemId, string $imageUrl): int;

    public function getCapabilities(): array;

    public function createCommonName(
        \Ecomero\ErpCore\Model\ResourceModel\Item\Collection $itemCollection
    ): bool;

    public function getErpExtVersion() : string;

    public function postProcessing(string $errorMessage): string;
}
