<?php

declare(strict_types=1);
/**
 *           a88888P8
 *          d8'
 * .d8888b. 88        .d8888b. 88d8b.d8b. .d8888b. .dd888b. .d8888b.
 * 88ooood8 88        88'  `88 88'`88'`88 88ooood8 88'    ` 88'  `88
 * 88.  ... Y8.       88.  .88 88  88  88 88.  ... 88       88.  .88
 * `8888P'   Y88888P8 `88888P' dP  dP  dP `8888P'  dP       `88888P'.
 *
 *           Copyright © eComero Management AB, All rights reserved.
 */

namespace Ecomero\ErpCore\Model\Rma;

use Ecomero\ErpCore\Helper\CronLock;
use Ecomero\ErpCore\Helper\ErpLogger;
use Ecomero\ErpCore\Helper\Notification;
use Ecomero\ErpCore\Helper\Settings;
use Ecomero\ErpCore\Model\Capability;
use Ecomero\ErpCore\Model\Erp\ErpRmaInterface;
use Magento\Framework\App\ProductMetadataInterface;
use Magento\Store\Model\StoreManagerInterface;

class RmaImport extends \Ecomero\ErpCore\Model\Executor
{
    protected $erp;
    protected $settings;
    protected $storeManager;
    protected $productMetadata;

    public function __construct(
        ErpLogger $logger,
        Notification $notification,
        ErpRmaInterface $erp,
        Settings $settings,
        CronLock $cronLock,
        StoreManagerInterface $storeManager,
        ProductMetadataInterface $productMetadata
    ) {
        parent::__construct(
            $logger,
            $cronLock,
            $notification,
            $erp
        );

        $this->erp = $erp;
        $this->settings = $settings;
        $this->storeManager = $storeManager;
        $this->productMetadata = $productMetadata;
    }

    public function processReturn(
        ErpLogger $logger,
        string $erpOrderNumber,
        string $webOrderNumber,
        string $receivedDate,
        string $reasonCode,
        string $comment,
        string $sku,
        int $qty
    ): void {
        // Override this method in plugin
    }

    protected function run(bool $force): string
    {
        return $this->import();
    }

    protected function getServiceDescription(): string
    {
        return 'rma import';
    }

    protected function getCapability(): string
    {
        return Capability::RETURN_IMPORT;
    }

    private function import(): string
    {
        if ('Enterprise' !== $this->productMetadata->getEdition()) {
            $this->logger->error('Returns are not available in Magento '.$this->productMetadata->getEdition().' edition.');

            return '';
        }

        $errorMessage = '';

        try {
            $this->logger->info('Retrieving returns from ERP');
            $json = $this->erp->getReturns();
            foreach ($json as $item) {
                $this->logger->info('Importing return for order '.$item->webOrderNumber.', sku '.$item->sku.', qty '.$item->qty);
                $this->processReturn(
                    $this->logger,
                    $item->erpOrderNumber,
                    $item->webOrderNumber,
                    $item->receivedDate,
                    $item->reasonCode,
                    $item->comment,
                    $item->sku,
                    $item->qty
                );
                $this->erp->setReturnAsProcessed($item->id);
            }
        } catch (\Throwable $exception) {
            $errorMessage = $errorMessage.$exception->getMessage();
            $this->logger->error($exception->getMessage());
        }

        if ('' !== $errorMessage && $this->settings->stopOnError()) {
            $this->notification->notify($errorMessage);

            return '';
        }

        return $errorMessage;
    }
}
