<?php
/**
 *
 *           a88888P8
 *          d8'
 * .d8888b. 88        .d8888b. 88d8b.d8b. .d8888b. .dd888b. .d8888b.
 * 88ooood8 88        88'  `88 88'`88'`88 88ooood8 88'    ` 88'  `88
 * 88.  ... Y8.       88.  .88 88  88  88 88.  ... 88       88.  .88
 * `8888P'   Y88888P8 `88888P' dP  dP  dP `8888P'  dP       `88888P'
 *
 *           Copyright © eComero Management AB, All rights reserved.
 *
 */
namespace Ecomero\Iframe\Helper;

class BrowserSupportSameSite
{
    protected $request;

    public function isSameSiteNoneCompatible($userAgent)
    {
        return !$this->isSameSiteNoneIncompatible($userAgent);
    }

    private function intToString($intValue)
    {
        return (string)$intValue;
    }

    private function stringToInt($strValue)
    {
        return (int)$strValue;
    }

    // Classes of browsers known to be incompatible.
    private function isSameSiteNoneIncompatible($useragent)
    {
        return (
            $this->hasWebKitSameSiteBug($useragent) ||
            $this->dropsUnrecognizedSameSiteCookies($useragent)
        );
    }

    private function hasWebKitSameSiteBug($useragent)
    {
        return (
            $this->isIosVersion(12, $useragent) ||
            ($this->isMacosxVersion(10, 14, $useragent) &&
                ($this->isSafari($useragent) || $this->isMacEmbeddedBrowser($useragent)))
        );
    }

    private function dropsUnrecognizedSameSiteCookies($useragent)
    {
        return (
            ($this->isChromiumBased($useragent) &&
            $this->isChromiumVersionAtLeast(51, $useragent) &&
                !$this->isChromiumVersionAtLeast(67, $useragent)) ||
            ($this->isUcBrowser($useragent) &&
                !$this->isUcBrowserVersionAtLeast(12, 13, 2, $useragent))
        );
    }

    // Regex parsing of User-Agent string.
    private function regexContains($stringValue, $regex)
    {
        return preg_match($regex, $stringValue) !== 0;
    }

    private function extractRegexMatch($stringValue, $regex, $offsetIndex)
    {
        $rc = preg_match($regex, $stringValue, $matches);

        if ($rc !== 0 && array_key_exists($offsetIndex, $matches)) {
            return $matches[$offsetIndex];
        }

        return null;
    }

    private function isIosVersion($major, $useragent)
    {
        $regex = '/\(iP.+; CPU .*OS (\d+)[_\d]*.*\) AppleWebKit\//';
        // Extract digits from first capturing group.
        return $this->extractRegexMatch($useragent, $regex, 1) === $this->intToString($major);
    }

    private function isMacosxVersion($major, $minor, $useragent)
    {
        $regex = '/\(Macintosh;.*Mac OS X (\d+)_(\d+)[_\d]*.*\) AppleWebKit\//';
        // Extract digits from first and second capturing groups.
        return (
            $this->extractRegexMatch($useragent, $regex, 1) === $this->intToString($major) &&
            $this->extractRegexMatch($useragent, $regex, 2) === $this->intToString($minor)
        );
    }

    private function isSafari($useragent)
    {
        $safari_regex = '/Version\/.* Safari\//';
        return (

            preg_match($safari_regex, $useragent) !== 0 &&
            !$this->isChromiumBased($useragent)
        );
    }

    private function isMacEmbeddedBrowser($useragent)
    {
        $regex = '/^Mozilla\/[\.\d]+ \(Macintosh;.*Mac OS X [_\d]+\) AppleWebKit\/[\.\d]+ \(KHTML, like Gecko\)$/';

        return $this->regexContains($useragent, $regex);
    }

    private function isChromiumBased($useragent)
    {
        $regex = '/Chrom(e|ium)/';
        return $this->regexContains($useragent, $regex);
    }

    private function isChromiumVersionAtLeast($major, $useragent)
    {
        $regex = '/Chrom[^ \/]+\/(\d+)[\.\d]* /';
        // Extract digits from first capturing group.
        $version = $this->stringToInt($this->extractRegexMatch($useragent, $regex, 1));
        return $version >= $major;
    }

    private function isUcBrowser($useragent)
    {
        $regex = '/UCBrowser\//';
        return $this->regexContains($useragent, $regex);
    }

    private function isUcBrowserVersionAtLeast($major, $minor, $build, $useragent)
    {
        $regex = '/UCBrowser\/(\d+)\.(\d+)\.(\d+)[\.\d]* /';
        // Extract digits from three capturing groups.
        $major_version = $this->stringToInt($this->extractRegexMatch($useragent, $regex, 1));
        $minor_version = $this->stringToInt($this->extractRegexMatch($useragent, $regex, 2));
        $build_version = $this->stringToInt($this->extractRegexMatch($useragent, $regex, 3));
        if ($major_version !== $major) {
            return $major_version > $major;
        }
        if ($minor_version != $minor) {
            return $minor_version > $minor;
        }

        return $build_version >= $build;
    }
}
