<?php
/**
 *
 *           a88888P8
 *          d8'
 * .d8888b. 88        .d8888b. 88d8b.d8b. .d8888b. .dd888b. .d8888b.
 * 88ooood8 88        88'  `88 88'`88'`88 88ooood8 88'    ` 88'  `88
 * 88.  ... Y8.       88.  .88 88  88  88 88.  ... 88       88.  .88
 * `8888P'   Y88888P8 `88888P' dP  dP  dP `8888P'  dP       `88888P'
 *
 *           Copyright © eComero Management AB, All rights reserved.
 *
 */
namespace Ecomero\Iframe\Plugin\Magento_Framework\App\Response\HeaderProvider;

use Ecomero\Iframe\Helper\Data;

/**
 * Plugin to disable X-Frame-Options header when iframe mode is enabled
 * 
 * This plugin prevents the X-Frame-Options header from being applied
 * when the store is configured to run in iframe mode, allowing the
 * store to be embedded in an iframe.
 */
class XFrameOptions
{
    /**
     * @param Data $data
     */
    public function __construct(
        protected readonly Data $data
    ) {
    }

    /**
     * Prevent X-Frame-Options header application when iframe mode is enabled
     * 
     * @param mixed $subject
     * @param callable $proceed
     * @return bool
     */
    public function aroundCanApply($subject, callable $proceed): bool
    {
        if ($this->data->isIFrameMode()) {
            return false;
        }
        
        return $proceed();
    }
}
