<?php
/**
 *
 *           a88888P8
 *          d8'
 * .d8888b. 88        .d8888b. 88d8b.d8b. .d8888b. .dd888b. .d8888b.
 * 88ooood8 88        88'  `88 88'`88'`88 88ooood8 88'    ` 88'  `88
 * 88.  ... Y8.       88.  .88 88  88  88 88.  ... 88       88.  .88
 * `8888P'   Y88888P8 `88888P' dP  dP  dP `8888P'  dP       `88888P'
 *
 *           Copyright © eComero Management AB, All rights reserved.
 *
 */
namespace Ecomero\Iframe\Plugin\Magento_Csp\Model\Policy;

use Ecomero\Iframe\Helper\Data;

/**
 * Plugin to modify CSP frame-ancestors policy when iframe mode is enabled
 * 
 * This plugin removes frame-ancestors restrictions when the store is configured
 * to run in iframe mode, allowing the store to be embedded in any iframe.
 */
class FetchPolicy
{
    /**
     * @param Data $data
     */
    public function __construct(
        protected readonly Data $data
    ) {
    }

    /**
     * Modify frame-ancestors policy when iframe mode is enabled
     * 
     * @param \Magento\Csp\Model\Policy\FetchPolicy $subject
     * @param string $result
     * @return string
     */
    public function afterGetValue(\Magento\Csp\Model\Policy\FetchPolicy $subject, string $result): string
    {
        if ($this->data->isIFrameMode() && $subject->getId() === 'frame-ancestors') {
            // Return '*' to allow any domain to embed in iframe
            return '*';
        }
        
        return $result;
    }
}