<?php declare(strict_types=1);

namespace Ecomero\Iframe\Rewrite\Magento\Framework\Session;

 use Magento\Framework\App\Config\ScopeConfigInterface;
 use Magento\Framework\App\DeploymentConfig;
 use Magento\Framework\App\RequestInterface;
 use Magento\Framework\Filesystem;
 use Magento\Framework\Stdlib\StringUtils;
 use Magento\Framework\ValidatorFactory;

 class Config extends \Magento\Framework\Session\Config
 {
     /**
      * @inheritDoc
      */
     public function __construct(
         ValidatorFactory $validatorFactory,
         ScopeConfigInterface $scopeConfig,
         StringUtils $stringHelper,
         RequestInterface $request,
         Filesystem $filesystem,
         DeploymentConfig $deploymentConfig,
         $scopeType,
         $lifetimePath = self::XML_PATH_COOKIE_LIFETIME
     ) {
         parent::__construct(
             $validatorFactory,
             $scopeConfig,
             $stringHelper,
             $request,
             $filesystem,
             $deploymentConfig,
             $scopeType,
             $lifetimePath
         );

         if ($this->_scopeConfig->isSetFlag('iframe/general/enabled', 'store')) {
             $this->setCookieDomain(null, $this->_httpRequest->getHttpHost());
             $this->setOption('session.cookie_samesite', 'None');
         }
     }
 }
