define(["Magento_PageBuilder/js/config"], function(_config) {
    "use strict";

    return function(image) {
        image.decodeUrl = function(value) {
            var result = "";

            value = decodeURIComponent(value.replace(window.location.href, ""));

            // Regexp was updated to support the mp4 file extension
            var regexp = /{{.*\s*url="?(.*\.([a-z|A-Z|1-9]*))"?\s*}}/;

            if (regexp.test(value)) {
                var _regexp$exec = regexp.exec(value),
                    url = _regexp$exec[1],
                    type = _regexp$exec[2];

                var image = {
                    name: url.split("/").pop(),
                    size: 0,
                    type: "image/" + type,
                    url: _config.getConfig("media_url") + url
                };

                result = [image];
            }

            return result;
        };

        return image;
    };
});
