define([
    'jquery'
], function ($) {
    'use strict';

    function createIntersectionObservers() {
        var source;

        if ("IntersectionObserver" in window) {
            window.lazyVideoObserver = new IntersectionObserver(function (entries) {
                entries.forEach(function (video) {
                    if (video.isIntersecting) {
                        var videoUrl = $(video.target).attr('data_src');
                        if (videoUrl !== undefined) {
 
                            video.target.src = videoUrl;
                            video.target.load();
                            video.target.classList.remove("lazy");
                            window.lazyVideoObserver.unobserve(video.target);   
                        }
                    }
                });
            });

            searchDomForVideos();
        }
    }

    function searchDomForVideos() {

        if( window.lazyVideoObserver !== undefined ) {
            var lazyVideos = [].slice.call(document.querySelectorAll("video.lazy"));

            lazyVideos.forEach(function (lazyVideo) {
                if( $(lazyVideo).hasClass("is_observing") === false) {
                    window.lazyVideoObserver.observe(lazyVideo);
                    $(lazyVideo).addClass("is_observing");    
                }
            });
        }
    }

    return function (config, element) {
        var element = $(element);

        if (document.readyState !== "loading") {
            createIntersectionObservers();
        } else {
            document.addEventListener("DOMContentLoaded", function () {
                createIntersectionObservers();
            });
        }
    };
});