define(["jquery", "mage/adminhtml/browser", "mage/translate"], function(
    $,
    browser,
    $t
) {
    "use strict";

    return function(orgImageUploader) {
        return orgImageUploader.extend({
            initialize: function() {
                this._super();

                if (
                    this.uploaderConfig.type === "media" &&
                    this.translations !== undefined
                ) {
                    this.translations.dragImageHere =
                        $t("Drag video here") +
                        " - MP4 PageBuilder Extension by eComero";
                    this.translations.uploadImage = $t("Upload Video");
                    this.translations.uploadNewImage = $t("Upload New Video");
                    this.placeholderType = "video";
                }

                if (this.uploaderConfig.type === "media") {
                    this.placeholderType = "video";
                }
            },

            openMediaBrowserDialog: function(imageUploader, e) {
                var $buttonEl = $(e.target),
                    openDialogUrl =
                        this.mediaGallery.openDialogUrl +
                        "target_element_id/" +
                        $buttonEl.attr("id") +
                        "/store/" +
                        this.mediaGallery.storeId +
                        "/type/" +
                        (this.uploaderConfig.type !== undefined
                            ? this.uploaderConfig.type
                            : "image") +
                        "/?isAjax=true"; // Changed type from "image" to "media"

                if (this.mediaGallery.initialOpenSubpath) {
                    openDialogUrl +=
                        "&current_tree_path=" +
                        Base64.mageEncode(this.mediaGallery.initialOpenSubpath);
                }

                browser.openDialog(
                    openDialogUrl,
                    null,
                    null,
                    this.mediaGallery.openDialogTitle
                );
            }
        });
    };
});
