<?php declare(strict_types=1);
/**
 *
 *           a88888P8
 *          d8'
 * .d8888b. 88        .d8888b. 88d8b.d8b. .d8888b. .dd888b. .d8888b.
 * 88ooood8 88        88'  `88 88'`88'`88 88ooood8 88'    ` 88'  `88
 * 88.  ... Y8.       88.  .88 88  88  88 88.  ... 88       88.  .88
 * `8888P'   Y88888P8 `88888P' dP  dP  dP `8888P'  dP       `88888P'
 *
 *           Copyright © eComero Management AB, All rights reserved.
 *
 */
namespace Ecomero\PunchOut\Controller\Ajax;

use Ecomero\PunchOut\Helper\Data;
use Magento\Catalog\Model\ProductRepository;
use Magento\Checkout\Model\Cart;
use Magento\ConfigurableProduct\Model\ResourceModel\Product\Type\Configurable;
use Magento\Customer\Model\Session;
use Magento\Framework\App\Action\Context;
use Magento\Framework\App\CsrfAwareActionInterface;
use Magento\Framework\App\Request\InvalidRequestException;
use Magento\Framework\App\RequestInterface;
use Magento\Framework\Controller\Result\JsonFactory;
use Magento\Quote\Model\Quote;
use Magento\Store\Model\StoreManagerInterface;

class CreateOrderOci extends \Magento\Framework\App\Action\Action implements CsrfAwareActionInterface
{
    protected $resultJsonFactory;
    protected $customerSession;
    protected $cart;
    protected $storeManager;

    public function __construct(
        Context $context,
        JsonFactory $resultJsonFactory,
        Session $customerSession,
        Cart $cart,
        StoreManagerInterface $storeManager,
        ProductRepository $productRepository,
        Configurable $configurableProduct,
        Data $data
    ) {
        $this->resultJsonFactory = $resultJsonFactory;
        $this->customerSession = $customerSession;
        $this->cart = $cart;
        $this->storeManager = $storeManager;
        $this->productRepository = $productRepository;
        $this->configurableProduct = $configurableProduct;
        $this->data = $data;
        parent::__construct($context);
    }

    public function createCsrfValidationException(RequestInterface $request): ? InvalidRequestException
    {
        return null;
    }

    public function validateForCsrf(RequestInterface $request): ?bool
    {
        return true;
    }

    public function createOrderFromCart(
        Quote $quote,
        string $currencyCode
    ) : array {
        $rc = [];

        foreach ($quote->getAllVisibleItems() as $item) {
            $product = $this->productRepository->get($item->getSku());
            $productId = $product->getId();
            $parentIds = $this->configurableProduct->getParentIdsByChild($productId);
            if (isset($parentIds[0])) {
                $productId = $parentIds[0];
            }

            $attrib = $product->getCustomAttribute($this->data->getUnit(Data::SCOPE_TYPE_STORE));
            if ($attrib !== null) {
                $unitOfMeasure = $attrib->getValue();
            } else {
                $unitOfMeasure = 'PR';
            }

            $code = '00000000';
            $attrib = $product->getCustomAttribute($this->data->getMaterialGroup(Data::SCOPE_TYPE_STORE));
            if ($attrib !== null) {
                $code = $attrib->getValue();
            }

            $leadTime = '1';
            $attrib = $product->getCustomAttribute($this->data->getLeadTime(Data::SCOPE_TYPE_STORE));
            if ($attrib !== null) {
                $leadTime = $attrib->getValue();
            }

            $variation = '';
            $variationAttributes = ['color', 'size'];
            foreach ($variationAttributes as $attributeName) {
                $attrib = $product->getCustomAttribute($attributeName);
                if ($attrib !== null) {
                    $variation = $attrib->getValue();
                    break;
                }
            }

            $ociItem = [

                'VENDORMAT' => $item->getSku(),
                'DESCRIPTION' => $item->getName(),
                'QUANTITY' => strval($item->getTotalQty()),
                'PRICE' => strval($item->getPrice()),
                'UNIT' => $unitOfMeasure ?? 'PR',
                'CURRENCY' => $currencyCode,
                'EXT_PRODUCT_ID' => $productId,
                'LONGTEXT' => $product->getDescription() ?? '',
                'ZZ_PROCESS_TYPE' => $variation,
                'LEADTIME' => $leadTime,
                'MATGROUP' => $code,
                'CUST_FIELD1' => $this->data->getCustomFieldValue(1),
                'CUST_FIELD2' => $this->data->getCustomFieldValue(2),
                'CUST_FIELD3' => $this->data->getCustomFieldValue(3),
                'CUST_FIELD4' => $this->data->getCustomFieldValue(4),
                'CUST_FIELD5' => $this->data->getCustomFieldValue(5)
            ];

            $rc [] = $ociItem;
        }

        return $rc;
    }

    public function execute()
    {
        $result = $this->resultJsonFactory->create();

        $rc = $this->createOrderFromCart(
            $this->cart->getQuote(),
            $this->storeManager->getStore()->getCurrentCurrency()->getCode()
        );

        $result->setData($rc);

        $result->setHeader('Cache-Control', 'no-cache', true);
        $result->setHeader('Access-Control-Allow-Headers', '*', true);
        $result->setHeader('Access-Control-Allow-Origin', '*', true);

        // Clear the session
        $this->cart->truncate()->save();
        $setup = $this->customerSession->unsetData('punchout');
        $this->customerSession->logout();

        return $result;
    }
}
