<?php declare(strict_types=1);
/**
 *
 *           a88888P8
 *          d8'
 * .d8888b. 88        .d8888b. 88d8b.d8b. .d8888b. .dd888b. .d8888b.
 * 88ooood8 88        88'  `88 88'`88'`88 88ooood8 88'    ` 88'  `88
 * 88.  ... Y8.       88.  .88 88  88  88 88.  ... 88       88.  .88
 * `8888P'   Y88888P8 `88888P' dP  dP  dP `8888P'  dP       `88888P'
 *
 *           Copyright © eComero Management AB, All rights reserved.
 *
 */
namespace Ecomero\PunchOut\Model\Config\Source;

use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Shipping\Model\Config;

class ShippingMethodList implements \Magento\Framework\Option\ArrayInterface
{
    protected $scopeConfig;
    protected $shippingConfig;

    public function __construct(
        ScopeConfigInterface $scopeConfig,
        Config $shippingConfig
    ) {
        $this->scopeConfig = $scopeConfig;
        $this->shippingConfig = $shippingConfig;
    }

    public function toOptionArray() : array
    {
        $methods = [];
        $activeCarriers = $this->shippingConfig->getActiveCarriers();
        foreach ($activeCarriers as $carrierCode => $carrierModel) {
            $options = [];
            if ($carrierMethods = $carrierModel->getAllowedMethods()) {
                foreach ($carrierMethods as $methodCode => $method) {
                    $code= $carrierCode . '_' . $methodCode;
                    $options[]=['value'=>$code,'label'=>$method];
                }
                $carrierTitle =$this->scopeConfig->getValue('carriers/' . $carrierCode . '/title');
            }
            $methods[]=['value'=>$options,'label'=>$carrierTitle];
        }
        if (count($methods) === 0) {
            $methods[]=['value'=>'invalid','label'=>'No shipping carrier'];
        }
        return $methods;
    }
}
