<?php declare(strict_types=1);
/**
 *
 *           a88888P8
 *          d8'
 * .d8888b. 88        .d8888b. 88d8b.d8b. .d8888b. .dd888b. .d8888b.
 * 88ooood8 88        88'  `88 88'`88'`88 88ooood8 88'    ` 88'  `88
 * 88.  ... Y8.       88.  .88 88  88  88 88.  ... 88       88.  .88
 * `8888P'   Y88888P8 `88888P' dP  dP  dP `8888P'  dP       `88888P'
 *
 *           Copyright © eComero Management AB, All rights reserved.
 *
 */
namespace Ecomero\PunchOut\Block;

use Ecomero\PunchOut\Api\SetupRepositoryInterface;
use Ecomero\PunchOut\Helper\Data;
use Ecomero\PunchOut\Helper\QuoteHelper;
use Magento\Checkout\Model\Session as CheckoutSession;
use Magento\Customer\Api\AccountManagementInterface;
use Magento\Customer\Api\CustomerRepositoryInterface;
use Magento\Customer\Model\CustomerFactory;
use Magento\Customer\Model\Session as CustomerSession;
use Magento\Framework\View\Element\Template\Context;

class Index extends \Magento\Framework\View\Element\Template
{
    protected $repository;
    protected $customerSession;
    protected $checkoutSession;
    protected $customerRepo;
    protected $customerFactory;
    protected $quoteHelper;
    protected $customerAccountManagement;
    protected $settings;

    public function __construct(
        Context $context,
        SetupRepositoryInterface $repository,
        CustomerSession $customerSession,
        CheckoutSession $checkoutSession,
        CustomerRepositoryInterface $customerRepo,
        CustomerFactory $customerFactory,
        QuoteHelper $quoteHelper,
        AccountManagementInterface $customerAccountManagement,
        Data $settings,
        array $data = []
    ) {
        $this->repository = $repository;
        $this->customerSession = $customerSession;
        $this->checkoutSession = $checkoutSession;
        $this->customerRepo = $customerRepo;
        $this->customerFactory = $customerFactory;
        $this->quoteHelper = $quoteHelper;
        $this->customerAccountManagement = $customerAccountManagement;
        $this->settings = $settings;
        parent::__construct($context, $data);
    }

    public function loginUser() : string
    {
        $rc = 'Login message not recognized';
        $this->customerSession->logout();

        $hookUrl = $this->getRequest()->getParam('HOOK_URL');
        $token = $this->getRequest()->getParam('token');
        if ($hookUrl !== null) {
            $rc = $this->loginUserOciRoundTrip();
        } elseif ($token !== null) {
            $rc = $this->loginUserCXML($token);
        }
        return $rc;
    }

    public function loginUserOciRoundTrip() : string
    {
        $rc = 'Username, Password or Hook is missing from URL';
        $username = $this->getRequest()->getParam('USERNAME');
        $password = $this->getRequest()->getParam('PASSWORD');
        $hookUrl = $this->getRequest()->getParam('HOOK_URL');
        $target = $this->getRequest()->getParam('~TARGET');

        if (!empty($username) && !empty($password) && !empty($hookUrl)) {
            try {
                $customer = $this->customerAccountManagement->authenticate($username, $password);

                $this->customerSession->setData(
                    'punchout',
                    (object) [  'type' => 'oci',
                                'hookUrl' => $hookUrl,
                                'target' => $target
                                ]
                );
                $rc = 'OK';
            } catch (EmailNotConfirmedException $e) {
                $rc = 'EmailNotConfirmedException';
            } catch (UserLockedException $e) {
                $rc = 'UserLockedException';
            } catch (AuthenticationException $e) {
                $rc = 'AuthenticationException';
            } catch (LocalizedException $e) {
                $rc = 'LocalizedException';
            } catch (\Exception $e) {
                $rc = 'Login failed';
            }
        }

        return $rc;
    }

    public function loginUserCXML(string $token) : string
    {
        $setup = $this->repository->getByToken($token);

        if ($setup === null) {
            return 'Invalid token';
        }

        $email = $setup->getRequestContactEmail();
        if ($email === null) {
            $extrinsic = unserialize($setup->getRequestExtrinsic());
            if (array_key_exists('UserEmail', $extrinsic)) {
                $email = $extrinsic['UserEmail'];
            }
        }
        if ($email === null) {
            return 'Invalid email';
        }

        try {
            $customer = $this->customerRepo->get($email);
            $customer = $this->customerFactory->create()->load($customer->getId());
        } catch (\Exception $exception) {
            return 'No user found for ' . $email;
        }

        $this->customerSession->setCustomerAsLoggedIn($customer);
        $this->customerSession->setData(
            'punchout',
            (object) [  'type' => 'cxml',
                        'hookUrl' => $setup->getRequestBrowserFormPostUrl(),
                        'data' => $setup]
        );
        $cartId = (int)$this->checkoutSession->getQuote()->getId();
        $this->quoteHelper->clearCart($cartId);

        if ($setup->getRequestOperation() === 'edit') {
            foreach ($setup->getItems() as $item) {
                $this->quoteHelper->addCartProduct(
                    $cartId,
                    (int)$item->getSupplierPartAuxiliaryId(),
                    $item->getSupplierPartId(),
                    $item->getQuantity()
                );
            }
        }
        return 'OK';
    }
}
