/**
 *
 *           a88888P8
 *          d8'
 * .d8888b. 88        .d8888b. 88d8b.d8b. .d8888b. .dd888b. .d8888b.
 * 88ooood8 88        88'  `88 88'`88'`88 88ooood8 88'    ` 88'  `88
 * 88.  ... Y8.       88.  .88 88  88  88 88.  ... 88       88.  .88
 * `8888P'   Y88888P8 `88888P' dP  dP  dP `8888P'  dP       `88888P'
 *
 *           Copyright © eComero Management AB, All rights reserved.
 *
 */
define([
    'jquery',
    'Magento_Customer/js/model/authentication-popup',
    'Magento_Customer/js/customer-data',
    'uiRegistry'
], function ($, authenticationPopup, customerData, UiRegistry) {
    'use strict';

    return function (config, element) {

        var punchoutSettings = customerData.get('punchout');
        if( punchoutSettings().type === 'oci' ||
            punchoutSettings().type === 'cxml') {
            $(element).show();
            $('#proceed-to-checkout-button').hide();
        } else {
            $(element).hide();
            $('#proceed-to-checkout-button').show();
        }

        $(element).click(function (event) {
            var cart = customerData.get('cart'),
                customer = customerData.get('customer');

            event.preventDefault();

            if (!customer().firstname && cart().isGuestCheckoutAllowed === false) {
                authenticationPopup.showModal();

                return false;
            }
            $(element).attr('disabled', true);

            UiRegistry.get('minicart_content').doPunchout();
        });

    };
});
