<?php declare(strict_types=1);
/**
 *
 *           a88888P8
 *          d8'
 * .d8888b. 88        .d8888b. 88d8b.d8b. .d8888b. .dd888b. .d8888b.
 * 88ooood8 88        88'  `88 88'`88'`88 88ooood8 88'    ` 88'  `88
 * 88.  ... Y8.       88.  .88 88  88  88 88.  ... 88       88.  .88
 * `8888P'   Y88888P8 `88888P' dP  dP  dP `8888P'  dP       `88888P'
 *
 *           Copyright © eComero Management AB, All rights reserved.
 *
 */
namespace Ecomero\PunchOut\Helper;

use Magento\Framework\Filesystem\Driver\File;

class Logger
{
    protected $logger;
    protected $fileSystem;
    protected $data;

    const MAGENTO_LOG_ROOT = BP . '/var/log/';
    const PUNCHOUT_LOG_ROOT = self::MAGENTO_LOG_ROOT . 'eComero';
    const FILE_PREFIX = 'punchout-';

    const RETENTION_1_DAY = 60 * 60 * 24 * 1;
    const RETENTION_7_DAY = 60 * 60 * 24 * 7;
    const RETENTION_14_DAY = 60 * 60 * 24 * 14;
    const RETENTION_30_DAY = 60 * 60 * 24 * 30;
    const RETENTION_90_DAY = 60 * 60 * 24 * 90;

    public function __construct(
        File $fileSystem,
        Data $data
    ) {
        $this->fileSystem = $fileSystem;
        $this->data = $data;

        if ($this->fileSystem->isDirectory(self::MAGENTO_LOG_ROOT)) {
            if (!$this->fileSystem->isDirectory(self::PUNCHOUT_LOG_ROOT)) {
                $this->fileSystem->createDirectory(self::PUNCHOUT_LOG_ROOT);
            }
            $this->logger = new \Zend\Log\Logger();
            $writer = new \Zend\Log\Writer\Stream($this->getActiveLogFile());
            $this->logger->addWriter($writer);
        }
    }

    public function deleteOldLogfiles() : void
    {
        $timeLimit = self::RETENTION_30_DAY;

        foreach ($this->fileSystem->readDirectory(self::PUNCHOUT_LOG_ROOT) as $fileName) {
            if (strpos($fileName, self::PUNCHOUT_LOG_ROOT . '/' . self::FILE_PREFIX) === 0) {
                $fileInfo = $this->fileSystem->stat($fileName);

                $mtime = $fileInfo['mtime'];
                $now   = time();
                if ($now - $mtime >= $timeLimit && $timeLimit !== 0) {
                    $this->fileSystem->deleteFile($fileName);
                }
            }
        }
    }

    private function getRealIpAddr() : string
    {
        if (!empty($_SERVER['HTTP_CLIENT_IP'])) {
            $ip = $_SERVER['HTTP_CLIENT_IP'];
        } elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
            $ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
        } else {
            $ip = $_SERVER['REMOTE_ADDR'];
        }
        return $ip;
    }

    public function getActiveLogFile() : string
    {
        return self::PUNCHOUT_LOG_ROOT . '/' . self::FILE_PREFIX . date("Ymd") . '.log';
    }

    public function error(string $message) : void
    {
        $this->logger->err('Request from ' . $this->getRealIpAddr() . "\n" . $message);
    }

    public function info(string $message) : void
    {
        if ($this->data->isExtendedLogging(Data::SCOPE_TYPE_STORE)) {
            $this->logger->log(1, 'Request from ' . $this->getRealIpAddr() . "\n" . $message);
        }
    }
}
