<?php declare(strict_types=1);
/**
 *
 *           a88888P8
 *          d8'
 * .d8888b. 88        .d8888b. 88d8b.d8b. .d8888b. .dd888b. .d8888b.
 * 88ooood8 88        88'  `88 88'`88'`88 88ooood8 88'    ` 88'  `88
 * 88.  ... Y8.       88.  .88 88  88  88 88.  ... 88       88.  .88
 * `8888P'   Y88888P8 `88888P' dP  dP  dP `8888P'  dP       `88888P'
 *
 *           Copyright © eComero Management AB, All rights reserved.
 *
 */
namespace Ecomero\PunchOut\Model;

use Ecomero\PunchOut\Helper\Data;

class ProfileMessage extends MessageBase
{
    public function __construct(
        Data $data
    ) {
        parent::__construct($data);
    }

    public function processProfileRequest(\SimpleXMLElement $xml, string $baseUrl) : array
    {
        $xmlResponse = $this->createXmlResponse((string)$xml['payloadID'], 200, 'OK');

        $response = $xmlResponse->Response->addChild('ProfileResponse');
        $transaction = $response->addChild('Transaction');
        $transaction->addAttribute('requestName', 'OrderRequest');
        $transaction->addChild('URL', $baseUrl);
        $transaction = $response->addChild('Transaction');
        $transaction->addAttribute('requestName', 'PunchOutSetupRequest');
        $transaction->addChild('URL', $baseUrl);

        return ['code' => 200,
                'xml' => $xmlResponse ];
    }
}
