<?php declare(strict_types=1);
/**
 *
 *           a88888P8
 *          d8'
 * .d8888b. 88        .d8888b. 88d8b.d8b. .d8888b. .dd888b. .d8888b.
 * 88ooood8 88        88'  `88 88'`88'`88 88ooood8 88'    ` 88'  `88
 * 88.  ... Y8.       88.  .88 88  88  88 88.  ... 88       88.  .88
 * `8888P'   Y88888P8 `88888P' dP  dP  dP `8888P'  dP       `88888P'
 *
 *           Copyright © eComero Management AB, All rights reserved.
 *
 */
namespace Ecomero\PunchOut\Model\Config\Source;

use Magento\Catalog\Model\ResourceModel\Product\Attribute\CollectionFactory;

class ProductAttributeList implements \Magento\Framework\Data\OptionSourceInterface
{
    protected $attributeFactory;

    public function __construct(
        CollectionFactory $attributeFactory
    ) {
        $this->attributeFactory = $attributeFactory;
    }

    public function toOptionArray() : array
    {
        $ret = [  'value' => '',
                  'label' => '*** USE DEFAULT ***'];
        $attributeCollection = $this->attributeFactory->create();
        $attributeCollection->setOrder('frontend_label', \Magento\Framework\Data\Collection::SORT_ORDER_ASC);
        foreach ($attributeCollection->getData() as $attrib) {
            if ($attrib['is_visible'] === "1") {
                $ret[] = [  'value' => $attrib['attribute_code'],
                            'label' => $attrib['frontend_label']];
            }
        }

        return $ret;
    }
}
