<?php declare(strict_types=1);
/**
 *
 *           a88888P8
 *          d8'
 * .d8888b. 88        .d8888b. 88d8b.d8b. .d8888b. .dd888b. .d8888b.
 * 88ooood8 88        88'  `88 88'`88'`88 88ooood8 88'    ` 88'  `88
 * 88.  ... Y8.       88.  .88 88  88  88 88.  ... 88       88.  .88
 * `8888P'   Y88888P8 `88888P' dP  dP  dP `8888P'  dP       `88888P'
 *
 *           Copyright © eComero Management AB, All rights reserved.
 *
 */
namespace Ecomero\PunchOut\Cron;

use Ecomero\PunchOut\Api\Data\SetupInterface;
use Ecomero\PunchOut\Api\SetupRepositoryInterface;
use Ecomero\PunchOut\Helper\Logger;
use Magento\Framework\Api\FilterBuilder;
use Magento\Framework\Api\SearchCriteriaBuilder;

class RunCleanup
{
    protected $logger;
    protected $repository;
    protected $searchCriteriaBuilder;
    protected $filterBuilder;

    public function __construct(
        Logger $logger,
        SetupRepositoryInterface $repository,
        SearchCriteriaBuilder $searchCriteriaBuilder,
        FilterBuilder $filterBuilder
    ) {
        $this->logger = $logger;
        $this->repository = $repository;
        $this->searchCriteriaBuilder = $searchCriteriaBuilder;
        $this->filterBuilder = $filterBuilder;
    }

    public function executeEvery5Minute() : void
    {
        $ts5minago = new \DateTime();
        $ts5minago = $ts5minago->sub(new \DateInterval('PT5M'));

        $timeFilter = $this->filterBuilder
                ->setField(SetupInterface::CREATED)
                ->setConditionType('lt')
                ->setValue($ts5minago->format('Y-m-d H:i:s'))
                ->create();
        $sessionFilter = $this->filterBuilder
                ->setField(SetupInterface::SESSION_ID)
                ->setConditionType('null')
                ->create();
        $this->searchCriteriaBuilder->addFilters([$timeFilter]);
        $this->searchCriteriaBuilder->addFilters([$sessionFilter]);
        $searchCriteria = $this->searchCriteriaBuilder->create();
        $oldSetupRequests  = $this->repository->getList($searchCriteria)->getItems();
        foreach ($oldSetupRequests as $value) {
            $this->logger->info('CRON: Delete old setup message with id ' . $value->getId());
            $this->repository->deleteById($value->getId());
        }

        $this->logger->deleteOldLogfiles();
    }
}
