<?php declare(strict_types=1);
/**
 *
 *           a88888P8
 *          d8'
 * .d8888b. 88        .d8888b. 88d8b.d8b. .d8888b. .dd888b. .d8888b.
 * 88ooood8 88        88'  `88 88'`88'`88 88ooood8 88'    ` 88'  `88
 * 88.  ... Y8.       88.  .88 88  88  88 88.  ... 88       88.  .88
 * `8888P'   Y88888P8 `88888P' dP  dP  dP `8888P'  dP       `88888P'
 *
 *           Copyright © eComero Management AB, All rights reserved.
 *
 */
namespace Ecomero\PunchOut\Api\Data;

interface SetupInterface
{
    const SETUP_ID = 'setup_id';
    const TOKEN = 'token';
    const SESSION_ID = 'session_id';
    const CREATED = 'created';
    const PAYLOAD_ID = 'payload_id';
    const TIMESTAMP = 'timestamp';
    const HEADER_FROM_DOMAIN = 'header_from_domain';
    const HEADER_FROM_IDENTITY = 'header_from_identity';
    const HEADER_TO_DOMAIN = 'header_to_domain';
    const HEADER_TO_IDENTITY = 'header_to_identity';
    const HEADER_SENDER_DOMAIN = 'header_sender_domain';
    const HEADER_SENDER_IDENTITY = 'header_sender_identity';
    const HEADER_SENDER_USER_AGENT = 'header_sender_user_agent';
    const REQUEST_DEPLOYMENT_MODE = 'req_deployment_mode';
    const REQUEST_OPERATION = 'req_operation';
    const REQUEST_BUYER_COOKIE = 'req_buyer_cookie';
    const REQUEST_BROWSER_FORM_POST_URL = 'req_browser_form_post_url';
    const REQUEST_SUPPLIER_SETUP_URL = 'req_supplier_setup_url';
    const REQUEST_EXTRINSIC = 'req_extrinsic';
    const REQUEST_CONTACT_NAME = 'req_contact_name';
    const REQUEST_CONTACT_EMAIL = 'req_contact_email';

    const REQUEST_SHIP_TO_ID = 'req_ship_to_id';
    const REQUEST_SHIP_TO_NAME = 'req_ship_to_name';
    const REQUEST_SHIP_TO_STREET = 'req_ship_to_street';
    const REQUEST_SHIP_TO_CITY = 'req_ship_to_city';
    const REQUEST_SHIP_TO_STATE = 'req_ship_to_state';
    const REQUEST_SHIP_TO_POSTAL_CODE = 'req_ship_to_postal_code';
    const REQUEST_SHIP_TO_COUNTRY = 'req_ship_to_country';

    public function getItems() : array;
    public function setItems(array $items);

    public function getToken() : string;
    public function setToken(string $token) : void;
    public function getSessionId() : ?string;
    public function setSessionId(string $sessionId) : void;
    public function getCreated() : ?\DateTime;
    public function setCreated(\DateTime $date) : void;

    public function getPayloadId() : string;
    public function setPayloadId(string $payloadId) : void;
    public function getTimeStamp() : ?\DateTime;
    public function setTimeStamp(\DateTime $date) : void;

    public function getHeaderFromDomain() : ?string;
    public function setHeaderFromDomain(string $domain) : void;
    public function getHeaderFromIdentity() : ?string;
    public function setHeaderFromIdentity(string $identity) : void;

    public function getHeaderToDomain() : ?string;
    public function setHeaderToDomain(string $domain) : void;
    public function getHeaderToIdentity() : ?string;
    public function setHeaderToIdentity(string $identity) : void;

    public function getHeaderSenderDomain() : ?string;
    public function setHeaderSenderDomain(string $domain) : void;
    public function getHeaderSenderIdentity() : string;
    public function setHeaderSenderIdentity(string $identity) : void;
    public function getHeaderSenderUserAgent() : ?string;
    public function setHeaderSenderUserAgent(string $userAgent) : void;

    public function getRequestDeploymentMode() : ?string;
    public function setRequestDeploymentMode(string $mode) : void;
    public function getRequestOperation() : string;
    public function setRequestOperation(string $operation) : void;
    public function getRequestBuyerCookie() : ?string;
    public function setRequestBuyerCookie(string $cookie) : void;
    public function getRequestBrowserFormPostUrl() : string;
    public function setRequestBrowserFormPostUrl(string $url) : void;
    public function getRequestSupplierSetupUrl() : string;
    public function setRequestSupplierSetupUrl(string $url) : void;

    public function getRequestExtrinsic() : ?string;
    public function setRequestExtrinsic(string $name) : void;

    public function getRequestContactName() : ?string;
    public function setRequestContactName(string $name) : void;
    public function getRequestContactEmail() : ?string;
    public function setRequestContactEmail(string $name) : void;

    public function getRequestShipToId() : ?string;
    public function setRequestShipToId(string $id) : void;
    public function getRequestShipToName() : ?string;
    public function setRequestShipToName(string $name) : void;
    public function getRequestShipToStreet() : ?string;
    public function setRequestShipToStreet(string $street) : void;
    public function getRequestShipToCity() : ?string;
    public function setRequestShipToCity(string $city) : void;
    public function getRequestShipToState() : ?string;
    public function setRequestShipToState(string $state) : void;
    public function getRequestShipToPostalCode() : ?string;
    public function setRequestShipToPostalCode(string $postalCode) : void;
    public function getRequestShipToCountry() : ?string;
    public function setRequestShipToCountry(string $country) : void;
}
