<?php declare(strict_types=1);
/**
 *
 *           a88888P8
 *          d8'
 * .d8888b. 88        .d8888b. 88d8b.d8b. .d8888b. .dd888b. .d8888b.
 * 88ooood8 88        88'  `88 88'`88'`88 88ooood8 88'    ` 88'  `88
 * 88.  ... Y8.       88.  .88 88  88  88 88.  ... 88       88.  .88
 * `8888P'   Y88888P8 `88888P' dP  dP  dP `8888P'  dP       `88888P'
 *
 *           Copyright © eComero Management AB, All rights reserved.
 *
 */
namespace Ecomero\PunchOut\Api;

use Magento\Framework\Api\SearchCriteriaInterface;
use Magento\Framework\Api\SearchResultsInterface;

interface SetupRepositoryInterface
{
    public function loadFromXml(\SimpleXMLElement $xml) : Data\SetupInterface;
    public function save(Data\SetupInterface $setup) : Data\SetupInterface;
    public function getById(string $setupId) : Data\SetupInterface;
    public function getByToken(string $token) : ?Data\SetupInterface;
    public function delete(Data\SetupInterface $setup) : Data\SetupInterface;
    public function deleteById(string $setupId) : Data\SetupInterface;
    public function getList(SearchCriteriaInterface $criteria) : SearchResultsInterface;
}
