<?php declare(strict_types=1);
/**
 *
 *           a88888P8
 *          d8'
 * .d8888b. 88        .d8888b. 88d8b.d8b. .d8888b. .dd888b. .d8888b.
 * 88ooood8 88        88'  `88 88'`88'`88 88ooood8 88'    ` 88'  `88
 * 88.  ... Y8.       88.  .88 88  88  88 88.  ... 88       88.  .88
 * `8888P'   Y88888P8 `88888P' dP  dP  dP `8888P'  dP       `88888P'
 *
 *           Copyright © eComero Management AB, All rights reserved.
 *
 */
namespace Ecomero\PunchOut\Test\Unit\Model;

use Ecomero\PunchOut\Api\Data\SetupItemInterfaceFactory;
use Ecomero\PunchOut\Model\ResourceModel\SetupItem\CollectionFactory;
use Ecomero\PunchOut\Model\Setup;
use Magento\Framework\Api\SearchCriteria\CollectionProcessorInterface;
use Magento\Framework\Api\SearchResultsInterfaceFactory;

class SetupItemRepositoryTest extends \PHPUnit\Framework\TestCase
{
    protected $setupItemRepositoryClass;
    protected $objectManager;

    const XML_DATA = '
          <ItemOut quantity="2">
            <ItemID>
              <SupplierPartID>RJB_Tsh1-DM</SupplierPartID>
              <SupplierPartAuxiliaryID>357</SupplierPartAuxiliaryID>
            </ItemID>
          </ItemOut>
    ';

    public function setUp() : void
    {
        $this->objectManager = new \Magento\Framework\TestFramework\Unit\Helper\ObjectManager($this);

        /** @var SetupItemInterfaceFactory&\PHPUnit\Framework\MockObject\MockObject $setupItemFactoryMock */
        $setupItemFactoryMock = $this->getMockBuilder(SetupItemInterfaceFactory::class)
          ->disableOriginalConstructor()
          ->getMock();

        $setupItemFactoryMock->method('create')->willReturn(
            $this->objectManager->getObject('Ecomero\PunchOut\Model\SetupItem')
        );

        /** @var CollectionFactory&\PHPUnit\Framework\MockObject\MockObject $collectionFactoryMock */
        $collectionFactoryMock = $this->getMockBuilder(CollectionFactory::class)
            ->disableOriginalConstructor()
            ->getMock();

        /** @var SearchResultsInterfaceFactory&\PHPUnit\Framework\MockObject\MockObject $searchResultsFactoryMock */
        $searchResultsFactoryMock = $this->getMockBuilder(SearchResultsInterfaceFactory::class)
            ->disableOriginalConstructor()
            ->getMock();

        /** @var CollectionProcessorInterface&\PHPUnit\Framework\MockObject\MockObject $collectionProcessorMock */
        $collectionProcessorMock = $this->getMockBuilder(CollectionProcessorInterface::class)
            ->disableOriginalConstructor()
            ->getMock();

        $this->setupItemRepositoryClass = new \Ecomero\PunchOut\Model\SetupItemRepository(
            $setupItemFactoryMock,
            $collectionFactoryMock,
            $searchResultsFactoryMock,
            $collectionProcessorMock
        );
    }

    public function testLoadFromXml() : void
    {
        $xml = new \SimpleXMLElement(SetupItemRepositoryTest::XML_DATA);

        /** @var \Ecomero\PunchOut\Model\SetupItem $rc */
        $rc =  $this->setupItemRepositoryClass->loadFromXml($xml);
        $this->assertEquals(2, $rc->getQuantity());
        $this->assertEquals('RJB_Tsh1-DM', $rc->getSupplierPartId());
        $this->assertEquals('357', $rc->getSupplierPartAuxiliaryId());
    }
}
