<?php

declare(strict_types=1);
/**
 *
 *           a88888P8
 *          d8'
 * .d8888b. 88        .d8888b. 88d8b.d8b. .d8888b. .dd888b. .d8888b.
 * 88ooood8 88        88'  `88 88'`88'`88 88ooood8 88'    ` 88'  `88
 * 88.  ... Y8.       88.  .88 88  88  88 88.  ... 88       88.  .88
 * `8888P'   Y88888P8 `88888P' dP  dP  dP `8888P'  dP       `88888P'
 *
 *           Copyright © eComero Management AB, All rights reserved.
 *
 */

namespace Ecomero\PunchOut\Helper;

use Laminas\Http\Client;
use Laminas\Http\Request;

class ProceedoHelper
{
    const PROCEEDO_ENDPOINT = "https://www.proceedo.net/connect/multipart";

    protected $client;
    protected $data;
    protected $logger;

    public function __construct(
        Client $client,
        Data $data,
        Logger $logger
    ) {
        $this->client = $client;
        $this->data = $data;
        $this->logger = $logger;
    }

    private function setHeaders(Request $request): void
    {
        $token = base64_encode($this->data->getProceedoUserName() . ':' . $this->data->getProceedoPassword());

        $request->getHeaders()->addHeaders([
            'User-Agent' => 'Magento',
            'Cache-Control' => 'no-cache',
            'Accept' => 'application/xml',
            'Authorization' => ('Basic ' . $token),
            'Accept-Encoding' => 'gzip'
        ]);
    }

    public function sendRequest(
        string $payLoad
    ): void {
        try {
            $this->client->reset();
            $request = new Request();
            $request->setUri(self::PROCEEDO_ENDPOINT);
            $request->setMethod(Request::METHOD_POST);
            $this->setHeaders($request);

            $request->setContent($payLoad);
            $request->getHeaders()->addHeaders([
                'Content-Length' => strlen($payLoad),
                'Content-Type' => 'application/xml'
            ]);

            $this->client->send($request);
            $response = $this->client->getResponse();
            if ($response->getStatusCode() != 200) {
                $this->logger->error('ProceedoHelper::sendRequest (status: ' . $response->getStatusCode() . ', content: ' . $response->getContent());
            }
        } catch (\Throwable $t) {
            $this->logger->error('ProceedoHelper::sendRequest ' . $t->getMessage());
        }
    }
}
