<?php declare(strict_types=1);
/**
 *
 *           a88888P8
 *          d8'
 * .d8888b. 88        .d8888b. 88d8b.d8b. .d8888b. .dd888b. .d8888b.
 * 88ooood8 88        88'  `88 88'`88'`88 88ooood8 88'    ` 88'  `88
 * 88.  ... Y8.       88.  .88 88  88  88 88.  ... 88       88.  .88
 * `8888P'   Y88888P8 `88888P' dP  dP  dP `8888P'  dP       `88888P'
 *
 *           Copyright © eComero Management AB, All rights reserved.
 *
 */
namespace Ecomero\PunchOut\Model;

use Ecomero\PunchOut\Api\SetupRepositoryInterface;
use Ecomero\PunchOut\Helper\Data;

class SetupMessage extends MessageBase
{
    protected $repository;

    public function __construct(
        SetupRepositoryInterface $repository,
        Data $data
    ) {
        $this->repository = $repository;
        parent::__construct($data);
    }

    public function processSetupRequest(\SimpleXMLElement $xml, string $baseUrl) : array
    {
        if (!$this->isAuthorized($xml)) {
            $xmlResponse = $this->createXmlResponse((string)$xml['payloadID'], 401, 'Unauthorized');

            return ['code' => 401,
                    'xml' => $xmlResponse ];
        }

        $setup = $this->repository->loadFromXml($xml);
        $token = md5(
            $setup->getTimeStamp()->format('Y-m-d\TH:i:sP') .
            $setup->getHeaderSenderIdentity() .
            strval(rand())
        );
        $setup->setToken($token);
        $setup->setCreated(new \DateTime());
        $setup = $this->repository->save($setup);

        $xmlResponse = $this->createXmlResponse((string)$xml['payloadID'], 200, 'OK');
        $xmlResponse->Response
            ->addChild('PunchOutSetupResponse')
            ->addChild('StartPage')
            ->addChild('URL', $baseUrl . 'punchout?token=' . $token);

        return ['code' => 200,
                'xml' => $xmlResponse ];
    }
}
