define(["jquery", "Magento_Customer/js/customer-data"], function(
    $,
    customerData
) {
    "use strict";

    return function(minicart) {
        return minicart.extend({
            initialize: function() {
                // Added the following lines to ensure the minicart
                // really reflects the correct content in PunchOut edit mode
                customerData.invalidate(["punchout"]);
                customerData.get("punchout").subscribe(
                    function(data) {
                        if (data.type === "oci" || data.type === "cxml" || data.type === "proceedo") {
                            customerData.invalidate(["cart"]);
                            customerData.reload(["cart"], true);
                        }

                    }
                );

                return this._super();
            },

            _addField: function(form, name, value) {
                $("<input>")
                    .attr({
                        type: "hidden",
                        value: value,
                        name: name
                    })
                    .appendTo(form);
            },

            _addProduct: function(
                row,
                sku,
                name,
                qty,
                price,
                unit,
                currency,
                externalId,
                description,
                variation,
                leadTime,
                matGroup,
                custField1,
                custField2,
                custField3,
                custField4,
                custField5
            ) {
                this._addField(
                    "#oci_form",
                    "NEW_ITEM-VENDORMAT[" + row + "]",
                    sku
                );
                this._addField(
                    "#oci_form",
                    "NEW_ITEM-DESCRIPTION[" + row + "]",
                    name
                );
                this._addField(
                    "#oci_form",
                    "NEW_ITEM-QUANTITY[" + row + "]",
                    qty
                );
                this._addField(
                    "#oci_form",
                    "NEW_ITEM-PRICE[" + row + "]",
                    price
                );
                this._addField("#oci_form", "NEW_ITEM-UNIT[" + row + "]", unit);
                this._addField(
                    "#oci_form",
                    "NEW_ITEM-CURRENCY[" + row + "]",
                    currency
                );
                this._addField(
                    "#oci_form",
                    "NEW_ITEM-EXT_PRODUCT_ID[" + row + "]",
                    externalId
                );
                this._addField(
                    "#oci_form",
                    "NEW_ITEM-LONGTEXT_" + row + ":132[]",
                    description
                );

                this._addField(
                    "#oci_form",
                    "NEW_ITEM-ZZ_PROCESS_TYPE[" + row + "]",
                    variation
                );
                this._addField(
                    "#oci_form",
                    "NEW_ITEM-LEADTIME[" + row + "]",
                    leadTime
                );
                this._addField(
                    "#oci_form",
                    "NEW_ITEM-MATGROUP[" + row + "]",
                    matGroup
                );

                if (custField1 !== "") {
                    this._addField(
                        "#oci_form",
                        "NEW_ITEM-CUST_FIELD1[" + row + "]",
                        custField1
                    );
                }

                if (custField2 !== "") {
                    this._addField(
                        "#oci_form",
                        "NEW_ITEM-CUST_FIELD2[" + row + "]",
                        custField2
                    );
                }

                if (custField3 !== "") {
                    this._addField(
                        "#oci_form",
                        "NEW_ITEM-CUST_FIELD3[" + row + "]",
                        custField3
                    );
                }

                if (custField4 !== "") {
                    this._addField(
                        "#oci_form",
                        "NEW_ITEM-CUST_FIELD4[" + row + "]",
                        custField4
                    );
                }

                if (custField5 !== "") {
                    this._addField(
                        "#oci_form",
                        "NEW_ITEM-CUST_FIELD1[" + row + "]",
                        custField5
                    );
                }
            },

            // https://stackoverflow.com/questions/8486099/how-do-i-parse-a-url-query-parameters-in-javascript
            _getJsonFromUrl: function(url) {
                var question = url.indexOf("?");
                var hash = url.indexOf("#");
                if (hash === -1 && question === -1) {
                    return {};
                }

                if (hash === -1) {
                    hash = url.length;
                }

                var query =
                    question === -1 || hash === question + 1
                        ? url.substring(hash)
                        : url.substring(question + 1, hash);

                var result = {};
                query.split("&").forEach(function(part) {
                    if (!part) return;

                    part = part.split("+").join(" "); // replace every + with space, regexp-free version
                    var eq = part.indexOf("=");
                    var key = eq > -1 ? part.substr(0, eq) : part;
                    var val =
                        eq > -1 ? decodeURIComponent(part.substr(eq + 1)) : "";
                    var from = key.indexOf("[");
                    if (from === -1) {
                        result[decodeURIComponent(key)] = val;
                    } else {
                        var to = key.indexOf("]", from);
                        var index = decodeURIComponent(
                            key.substring(from + 1, to)
                        );
                        key = decodeURIComponent(key.substring(0, from));
                        if (!result[key]) {
                            result[key] = [];
                        }
                        if (!index) {
                            result[key].push(val);
                        } else {
                            result[key][index] = val;
                        }
                    }
                });
                return result;
            },

            isPunchoutSession: function() {
                var punchoutSettings = customerData.get("punchout");

                return (
                    punchoutSettings().type === "oci" ||
                    punchoutSettings().type === "cxml" ||
                    punchoutSettings().type === "proceedo"
                );
            },

            doPunchout: function() {
                var punchoutSettings = customerData.get("punchout");

                if (punchoutSettings().type === "cxml") {
                    $.ajax({
                        url: punchoutSettings().baseUrl + "/punchout/Ajax/CreateOrderXml",
                        type: "POST",
                        dataType: "xml"
                    }).done(function(orderMessage) {
                        var strOrderMessageXml = new XMLSerializer().serializeToString(
                            orderMessage
                        );
                        $("#cxml_form").attr(
                            "action",
                            punchoutSettings().hookUrl
                        );
                        $("#cXML-urlencoded").val(strOrderMessageXml);
                        $("#cxml_form").submit();
                    });
                } else if (punchoutSettings().type === "proceedo") {
                    $.ajax({
                        url: punchoutSettings().baseUrl + "/punchout/Ajax/CreateOrderProceedo",
                        type: "POST",
                        dataType: "text"
                    }).done(function(orderMessage) {
                        $('form[name="basket"]').attr(
                            "action",
                            punchoutSettings().hookUrl
                        );
                        $('input[name="shoppingbasket"]').val(orderMessage);
                        $('input[name="buyercookie"]').val(punchoutSettings().cookie);
                        $('input[name="prosupplierid"]').val(punchoutSettings().prosupplierid);
                        $('input[name="prosuppliername"]').val(punchoutSettings().prosuppliername);

                        $('form[name="basket"]').submit();
                    });
                } else if (punchoutSettings().type === "oci") {
                    $.ajax({
                        url: punchoutSettings().baseUrl + "/punchout/Ajax/CreateOrderOci",
                        type: "POST",
                        dataType: "json"
                    }).done(
                        function(orderMessage) {
                            var parameters = this._getJsonFromUrl(
                                punchoutSettings().hookUrl
                            );
                            for (var key in parameters) {
                                this._addField(
                                    "#oci_form",
                                    key,
                                    parameters[key]
                                );
                            }

                            var hookUrl = punchoutSettings().hookUrl.split(
                                /[?#]/
                            )[0];
                            $("#oci_form").attr("action", hookUrl);
                            if (punchoutSettings().target) {
                                $("#oci_form").attr(
                                    "target",
                                    punchoutSettings().target
                                );
                            }

                            for (
                                var row = 1;
                                row <= orderMessage.length;
                                row++
                            ) {
                                this._addProduct(
                                    row,
                                    orderMessage[row - 1].VENDORMAT,
                                    orderMessage[row - 1].DESCRIPTION,
                                    orderMessage[row - 1].QUANTITY,
                                    orderMessage[row - 1].PRICE,
                                    orderMessage[row - 1].UNIT,
                                    orderMessage[row - 1].CURRENCY,
                                    orderMessage[row - 1].EXT_PRODUCT_ID,
                                    orderMessage[row - 1].LONGTEXT,
                                    orderMessage[row - 1].ZZ_PROCESS_TYPE,
                                    orderMessage[row - 1].LEADTIME,
                                    orderMessage[row - 1].MATGROUP,
                                    orderMessage[row - 1].CUST_FIELD1,
                                    orderMessage[row - 1].CUST_FIELD2,
                                    orderMessage[row - 1].CUST_FIELD3,
                                    orderMessage[row - 1].CUST_FIELD4,
                                    orderMessage[row - 1].CUST_FIELD5
                                );
                            }

                            $("#oci_form").submit();
                        }.bind(this)
                    );
                }
            }
        });
    };
});
