<?php declare(strict_types=1);
/**
 *
 *           a88888P8
 *          d8'
 * .d8888b. 88        .d8888b. 88d8b.d8b. .d8888b. .dd888b. .d8888b.
 * 88ooood8 88        88'  `88 88'`88'`88 88ooood8 88'    ` 88'  `88
 * 88.  ... Y8.       88.  .88 88  88  88 88.  ... 88       88.  .88
 * `8888P'   Y88888P8 `88888P' dP  dP  dP `8888P'  dP       `88888P'
 *
 *           Copyright © eComero Management AB, All rights reserved.
 *
 */
namespace Ecomero\PunchOut\Controller\Ajax;

use Ecomero\PunchOut\Model\Proceedo\OrderMessage;
use Magento\Checkout\Model\Cart;
use Magento\Customer\Model\Session;
use Magento\Framework\App\Action\Context;
use Magento\Framework\App\CsrfAwareActionInterface;
use Magento\Framework\App\Request\InvalidRequestException;
use Magento\Framework\App\RequestInterface;
use Magento\Framework\Controller\Result\RawFactory;
use Magento\Store\Model\StoreManagerInterface;

class CreateOrderProceedo extends \Magento\Framework\App\Action\Action implements CsrfAwareActionInterface
{
    protected $resultRawFactory;
    protected $customerSession;
    protected $cart;
    protected $storeManager;
    protected $orderMessage;

    public function __construct(
        Context $context,
        RawFactory  $resultRawFactor,
        Session $customerSession,
        Cart $cart,
        StoreManagerInterface $storeManager,
        OrderMessage $orderMessage
    ) {
        $this->resultRawFactory = $resultRawFactor;
        $this->customerSession = $customerSession;
        $this->cart = $cart;
        $this->storeManager = $storeManager;
        $this->orderMessage = $orderMessage;
        parent::__construct($context);
    }

    public function createCsrfValidationException(RequestInterface $request): ? InvalidRequestException
    {
        return null;
    }

    public function validateForCsrf(RequestInterface $request): ?bool
    {
        return true;
    }

    public function execute()
    {
        $result = $this->resultRawFactory->create();

        $punchoutConfig = $this->customerSession->getData('punchout');

        if ($punchoutConfig === null) {
            $result->setContents('no valid punchout session');
            $result->setStatusHeader(500);
            return $result;
        }

        $xml = $this->orderMessage->createOrderFromCart(
            $this->cart->getQuote(),
            $this->storeManager->getStore()->getCurrentCurrency()->getCode(),
            $punchoutConfig->cookie,
            $punchoutConfig->prosupplierid,
            $punchoutConfig->prosuppliername
        );

        $result->setContents(base64_encode($xml));
        $result->setStatusHeader(200);

        $result->setHeader('Cache-Control', 'no-cache', true);
        $result->setHeader('Content-Type', 'application/xml', true);
        $result->setHeader('Access-Control-Allow-Headers', '*', true);
        $result->setHeader('Access-Control-Allow-Origin', '*', true);

        // Clear the session
        $this->cart->truncate()->save();
        $setup = $this->customerSession->unsetData('punchout');
        $this->customerSession->logout();

        return $result;
    }
}
