<?php declare(strict_types=1);
/**
 *
 *           a88888P8
 *          d8'
 * .d8888b. 88        .d8888b. 88d8b.d8b. .d8888b. .dd888b. .d8888b.
 * 88ooood8 88        88'  `88 88'`88'`88 88ooood8 88'    ` 88'  `88
 * 88.  ... Y8.       88.  .88 88  88  88 88.  ... 88       88.  .88
 * `8888P'   Y88888P8 `88888P' dP  dP  dP `8888P'  dP       `88888P'
 *
 *           Copyright © eComero Management AB, All rights reserved.
 *
 */
namespace Ecomero\PunchOut\Test\Unit\Model;

use Ecomero\PunchOut\Helper\Data;

class ProfileMessageTest extends \PHPUnit\Framework\TestCase
{
    protected $profileMessageClass;

    const XML_DATA = '<?xml version="1.0" encoding="UTF-8"?>
    <!DOCTYPE cXML SYSTEM "http://xml.cxml.org/schemas/cXML/1.2.041/cXML.dtd">
    <cXML payloadID="1577107986.2072@punchoutcommerce.com" timestamp="2019-12-23T13:33:06+00:00">
    </cXML>
    ';
    public function setUp() : void
    {
        /** @var Data&\PHPUnit\Framework\MockObject\MockObject $dataMock */
        $dataMock = $this->getMockBuilder(Data::class)
            ->disableOriginalConstructor()
            ->getMock();

        $this->profileMessageClass = new \Ecomero\PunchOut\Model\ProfileMessage(
            $dataMock
        );
    }

    public function testProcessProfileRequest() : void
    {
        $xml = new \SimpleXMLElement(ProfileMessageTest::XML_DATA);

        $rc = $this->profileMessageClass->processProfileRequest($xml, 'https://www.acme.com');
        $this->assertEquals(200, $rc['code']);
    }
}
