<?php declare(strict_types=1);
/**
 *
 *           a88888P8
 *          d8'
 * .d8888b. 88        .d8888b. 88d8b.d8b. .d8888b. .dd888b. .d8888b.
 * 88ooood8 88        88'  `88 88'`88'`88 88ooood8 88'    ` 88'  `88
 * 88.  ... Y8.       88.  .88 88  88  88 88.  ... 88       88.  .88
 * `8888P'   Y88888P8 `88888P' dP  dP  dP `8888P'  dP       `88888P'
 *
 *           Copyright © eComero Management AB, All rights reserved.
 *
 */
namespace Ecomero\PunchOut\Plugin\Magento\Framework\App\FrontController;

use Magento\Customer\Model\Session;
use Magento\Store\Model\StoreManagerInterface;
use Magento\Framework\App\ResponseFactory;

class RequestPreprocessor
{
    protected $responseFactory;
    protected $storeManager;
    protected $customerSession;

    public function __construct(
        StoreManagerInterface $storeManager,
        ResponseFactory $responseFactory,
        Session $customerSession
    ) {
        $this->storeManager = $storeManager;
        $this->responseFactory = $responseFactory;
        $this->customerSession = $customerSession;
    }

    public function aroundDispatch(
        \Magento\Framework\App\FrontController $subject,
        \Closure $proceed,
        \Magento\Framework\App\RequestInterface $request
    ) {

        $pubchoutSession = $this->customerSession->getData('punchout');
        if ($pubchoutSession) {

            if( $this->storeManager->getStore()->getCode() != $pubchoutSession->store ) {

                $response = $this->responseFactory->create();
                $response->setRedirect($pubchoutSession->baseUrl, 302);
                $response->setNoCacheHeaders();
                return $response;

            }
        }
        $request->setDispatched(false);

        return $proceed($request);
    }
}
