<?php declare(strict_types=1);
/**
 *
 *           a88888P8
 *          d8'
 * .d8888b. 88        .d8888b. 88d8b.d8b. .d8888b. .dd888b. .d8888b.
 * 88ooood8 88        88'  `88 88'`88'`88 88ooood8 88'    ` 88'  `88
 * 88.  ... Y8.       88.  .88 88  88  88 88.  ... 88       88.  .88
 * `8888P'   Y88888P8 `88888P' dP  dP  dP `8888P'  dP       `88888P'
 *
 *           Copyright © eComero Management AB, All rights reserved.
 *
 */
namespace Ecomero\PunchOut\Test\Unit\Block;

use Ecomero\PunchOut\Helper\Data;
use Ecomero\PunchOut\Helper\QuoteHelper;
use Ecomero\PunchOut\Model\Setup;
use Ecomero\PunchOut\Model\SetupItem;
use Ecomero\PunchOut\Model\SetupRepository;
use Magento\Checkout\Model\Session as CheckoutSession;
use Magento\Customer\Api\AccountManagementInterface;
use Magento\Customer\Model\Customer;
use Magento\Customer\Model\CustomerFactory;
use Magento\Customer\Model\ResourceModel\CustomerRepository;
use Magento\Customer\Model\Session as CustomerSession;
use Magento\Framework\View\Element\Template\Context;
use Magento\Quote\Model\Quote;
use Magento\TestFramework\Request;

class IndexTest extends \PHPUnit\Framework\TestCase
{
    protected $blockIndexClass;
    protected $objectManager;

    public function setUp() : void
    {
        $this->objectManager = new \Magento\Framework\TestFramework\Unit\Helper\ObjectManager($this);

        /** @var Request&\PHPUnit\Framework\MockObject\MockObject $requestMock */
        $requestMock = $this->getMockBuilder(Request::class)
            ->setMethods(['getParam'])
            ->disableOriginalConstructor()
            ->getMock();
        $requestMock->method('getParam')->willReturn('28d268ee1b9b329eb2a9f46d3e7f70d9');

        /** @var Context&\PHPUnit\Framework\MockObject\MockObject $contextMock */
        $contextMock = $this->getMockBuilder(Context::class)
            ->disableOriginalConstructor()
            ->setMethods(['getRequest'])
            ->getMock();

        $contextMock->expects($this->any())->method('getRequest')->willReturn($requestMock);

        /** @var SetupItem&\PHPUnit\Framework\MockObject\MockObject $setupItemMock */
        $setupItemMock = $this->getMockBuilder(Setup::class)
            ->setMethods(['getSupplierPartAuxiliaryId','getSupplierPartId','getQuantity'])
            ->disableOriginalConstructor()
            ->getMock();
        $setupItemMock->method('getSupplierPartAuxiliaryId')->willReturn(21);
        $setupItemMock->method('getSupplierPartId')->willReturn('sku123');
        $setupItemMock->method('getQuantity')->willReturn(4.0);

        /** @var Setup&\PHPUnit\Framework\MockObject\MockObject $setupMock */
        $setupMock = $this->getMockBuilder(Setup::class)
            ->disableOriginalConstructor()
            ->setMethods(['getRequestContactEmail', 'getRequestOperation', 'getItems'])
            ->getMock();

        $setupMock->method('getRequestContactEmail')->willReturn('john.doe@acme.com');
        $setupMock->method('getRequestOperation')->willReturn('edit');
        $setupMock->method('getItems')->willReturn([$setupItemMock, $setupItemMock]);

        /** @var SetupRepository&\PHPUnit\Framework\MockObject\MockObject $setupRepositoryInterfaceMock */
        $setupRepositoryInterfaceMock = $this->getMockBuilder(SetupRepository::class)
            ->disableOriginalConstructor()
            ->setMethods(['getByToken'])
            ->getMock();

        $setupRepositoryInterfaceMock->method('getByToken')
            ->willReturn($setupMock);

        /** @var CustomerSession&\PHPUnit\Framework\MockObject\MockObject $customerSessionMock */
        $customerSessionMock = $this->getMockBuilder(CustomerSession::class)
            ->disableOriginalConstructor()
            ->getMock();

        /** @var Quote&\PHPUnit\Framework\MockObject\MockObject $quoteMock */
        $quoteMock = $this->getMockBuilder(Quote::class)
            ->disableOriginalConstructor()
            ->getMock();

        /** @var CheckoutSession&\PHPUnit\Framework\MockObject\MockObject $checkoutSessionMock */
        $checkoutSessionMock = $this->getMockBuilder(CheckoutSession::class)
            ->setMethods(['getQuote'])
            ->disableOriginalConstructor()
            ->getMock();
        $checkoutSessionMock->method('getQuote')
            ->willReturn($quoteMock);

        /** @var Customer&\PHPUnit\Framework\MockObject\MockObject $customerMock */
        $customerMock = $this->getMockBuilder(Customer::class)
            ->disableOriginalConstructor()
            ->getMock();

        /** @var CustomerRepository&\PHPUnit\Framework\MockObject\MockObject $customerRepositoryMock */
        $customerRepositoryMock = $this->getMockBuilder(CustomerRepository::class)
            ->disableOriginalConstructor()
            ->setMethods(['get'])
            ->getMock();
        $customerRepositoryMock->method('get')
            ->willReturn($customerMock);

        /** @var CustomerFactory&\PHPUnit\Framework\MockObject\MockObject $customerFactoryMock */
        $customerFactoryMock = $this->getMockBuilder(CustomerFactory::class)
            ->disableOriginalConstructor()
            ->setMethods(['create'])
            ->getMock();
        $customerFactoryMock->method('create')
            ->willReturn($customerMock);

        /** @var QuoteHelper&\PHPUnit\Framework\MockObject\MockObject $quoteHelperMock */
        $quoteHelperMock = $this->getMockBuilder(QuoteHelper::class)
            ->disableOriginalConstructor()
            ->getMock();

        /** @var AccountManagementInterface&\PHPUnit\Framework\MockObject\MockObject $accountManagerMock */
        $accountManagerMock = $this->getMockBuilder(AccountManagementInterface::class)
        ->disableOriginalConstructor()
        ->getMock();

        /** @var Data&\PHPUnit\Framework\MockObject\MockObject $dataMock */
        $dataMock = $this->getMockBuilder(Data::class)
            ->disableOriginalConstructor()
            ->getMock();

        $this->blockIndexClass = new \Ecomero\PunchOut\Block\Index(
            $contextMock,
            $setupRepositoryInterfaceMock,
            $customerSessionMock,
            $checkoutSessionMock,
            $customerRepositoryMock,
            $customerFactoryMock,
            $quoteHelperMock,
            $accountManagerMock,
            $dataMock,
            []
        );
    }

    public function testLoginUser() : void
    {
        $rc =  $this->blockIndexClass->loginUser();
        $this->assertEquals('OK', $rc);
    }
}
